/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.ling;

import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Objects;
import it.uniroma1.lcl.jlt.util.ScoredItem;
import it.uniroma1.lcl.jlt.util.ScoredStringComparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Word {
    public static final Word DUMMY_WORD = new Word("");
    private final String word;
    private POS pos;
    private String id;
    private Language language;
    private SortedSet<ScoredItem<String>> labels;
    private SortedSet<ScoredItem<String>> goldLabels;
    private boolean bDisambiguable = false;

    public Word(String word) {
        this(word, null);
    }

    public Word(String word, char pos) {
        this(word, "" + pos);
    }

    public Word(String word, String pos) {
        this(word, pos, (String)null);
    }

    public Word(String word, String pos, String id) {
        this(word, pos, id, null);
    }

    public Word(String word, char pos, Language language) {
        this(word, "" + pos, null, language);
    }

    public Word(String word, String pos, Language language) {
        this(word, pos, null, language);
    }

    public Word(String word, String pos, String id, Language language) {
        this.word = word;
        this.id = id;
        this.pos = pos == null ? null : POS.getPartOfSpeech((char)pos.charAt(0));
        this.language = language;
        this.labels = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
        this.goldLabels = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
    }

    public Word(Word other) {
        this.word = other.word;
        this.id = other.id;
        this.pos = other.pos;
        this.labels = new TreeSet<ScoredItem<String>>(other.getLabels());
        this.goldLabels = new TreeSet<ScoredItem<String>>(other.getGoldLabels());
    }

    public String getWord() {
        return this.word;
    }

    public POS getPOS() {
        return this.pos;
    }

    public void setPOS(POS pos) {
        this.pos = pos;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.word);
        if (this.pos != null) {
            buffer.append("#").append(this.pos.getTag());
        }
        if (this.id != null) {
            buffer.append(" [").append(this.id).append("]");
        }
        if (this.language != null) {
            buffer.append("[").append((Object)this.language).append("]");
        }
        if (this.labels != null) {
            buffer.append(" ").append(this.labels);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Word) {
            Word other = (Word)obj;
            return this.word.equals(other.getWord()) && Objects.equalsWithNull(this.pos, other.getPOS()) && Objects.equalsWithNull(this.id, other.id) && Objects.equalsWithNull((Object)this.language, (Object)other.getLanguage());
        }
        return false;
    }

    public int hashCode() {
        return this.word.hashCode() + (this.pos != null ? this.pos.hashCode() : 0) + (this.id != null ? this.id.hashCode() : 0) + (this.language != null ? this.language.hashCode() : 0);
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public void setDisambiguable(boolean bDisambiguable) {
        this.bDisambiguable = bDisambiguable;
    }

    public boolean isDisambiguable() {
        return this.bDisambiguable;
    }

    public void addLabel(String label, double weight) {
        this.addLabel(new ScoredItem<String>(label, weight));
    }

    public void addLabel(ScoredItem<String> response) {
        this.labels.add(response);
    }

    public void setLabels(SortedSet<ScoredItem<String>> labels) {
        this.labels = labels;
    }

    public Set<ScoredItem<String>> getLabels() {
        return this.labels;
    }

    public void addGoldLabel(String gold, double weight) {
        this.addGoldLabel(new ScoredItem<String>(gold, weight));
    }

    public void addGoldLabel(ScoredItem<String> gold) {
        this.goldLabels.add(gold);
    }

    public void setGoldLabels(SortedSet<ScoredItem<String>> goldLabels) {
        this.goldLabels = goldLabels;
    }

    public Set<ScoredItem<String>> getGoldLabels() {
        return this.goldLabels;
    }

    public Set<ScoredItem<String>> getBestLabels() {
        double bestScore = 0.0;
        TreeSet<ScoredItem<String>> best = new TreeSet<ScoredItem<String>>(new ScoredStringComparator());
        for (ScoredItem scoredItem : this.labels) {
            if (best.isEmpty()) {
                best.add(scoredItem);
                bestScore = scoredItem.getScore();
                continue;
            }
            if (scoredItem.getScore() != bestScore) break;
            best.add(scoredItem);
        }
        return best;
    }
}

