/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.jweb1t.EnhancedJWeb1TSearcher;
import it.uniroma1.lcl.jlt.jweb1t.JWeb1TSearcher;
import it.uniroma1.lcl.jlt.util.LongCounter;
import it.uniroma1.lcl.jlt.util.Timer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StdEnhancedJWeb1TSearcher {
    private final Log logger = LogFactory.getLog(StdEnhancedJWeb1TSearcher.class);
    private static final String indexPath = Configuration.getInstance().getJWeb1TDir();
    private static EnhancedJWeb1TSearcher searcher;
    private static JWeb1TSearcher simpleSearcher;
    private Timer timer = new Timer();

    public StdEnhancedJWeb1TSearcher() {
        try {
            File indexFile = new File(indexPath);
            int nMin = 1;
            int nMax = 5;
            searcher = new EnhancedJWeb1TSearcher(indexFile, nMin, nMax);
            simpleSearcher = new JWeb1TSearcher(indexFile, nMin, nMax);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void startSearch() {
    }

    protected void endSearch() {
        this.logger.info((Object)("Search time:" + this.timer.getElapsedTimeInString() + " [" + this.timer.getTimeInString() + " ms]"));
    }

    public long getNGramFrequency(String query) {
        this.startSearch();
        try {
            long l = simpleSearcher.getFrequency(query);
            return l;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.endSearch();
        }
        return 0L;
    }

    public LongCounter<String> getMatchingNGrams(String query) {
        return this.getMatchingNGrams(query, false);
    }

    public LongCounter<String> getMatchingNGrams(String query, boolean bCaseSensitive) {
        this.startSearch();
        try {
            LongCounter<String> longCounter = searcher.getAllMatchingNgrams(query, bCaseSensitive);
            return longCounter;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.endSearch();
        }
        return new LongCounter<String>();
    }
}

