/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.FolderScanner;
import it.uniroma1.lcl.jlt.jweb1t.FrequencyDistribution;
import it.uniroma1.lcl.jlt.jweb1t.IndexFilter;
import it.uniroma1.lcl.jlt.jweb1t.Searcher;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JWeb1TSearcherInMemory
implements Searcher {
    private final Log logger = LogFactory.getLog(JWeb1TSearcherInMemory.class);
    private final Map<Integer, FrequencyDistribution<String>> ngramLevelMap = new HashMap<Integer, FrequencyDistribution<String>>();
    private Map<Integer, Long> ngramCountMap;
    private Map<Integer, Long> ngramDistinctCountMap;

    public JWeb1TSearcherInMemory(String ngramLocation, int maxNgramSize) throws IOException {
        File ngramBaseDir = new File(ngramLocation);
        this.initialize(ngramBaseDir);
        int level = 1;
        while (level <= maxNgramSize) {
            this.ngramLevelMap.put(level, new FrequencyDistribution());
            File ngramFile = new File(ngramBaseDir, String.valueOf(level) + "gms/");
            if (ngramFile.isFile()) {
                this.fillMap(ngramFile, level);
            } else {
                if (!ngramFile.isDirectory()) {
                    throw new IOException(ngramFile + " is not a directory.");
                }
                FolderScanner scanner = new FolderScanner(ngramFile);
                scanner.setFilter(new IndexFilter());
                while (scanner.hasNext()) {
                    File[] files = scanner.next();
                    int i = 0;
                    while (i < files.length) {
                        this.fillMap(files[i], level);
                        ++i;
                    }
                }
            }
            ++level;
        }
    }

    private void fillMap(File aFile, int aLevel) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new FileReader(aFile));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts.length != 2) continue;
            this.ngramLevelMap.get(aLevel).addSample(parts[0], Long.parseLong(parts[1]));
        }
        reader.close();
    }

    private void initialize(File baseDir) throws NumberFormatException, IOException {
        this.ngramCountMap = new HashMap<Integer, Long>();
        this.ngramDistinctCountMap = new HashMap<Integer, Long>();
        File countFile = new File(baseDir, "aggregated_counts.cnt");
        if (countFile.exists()) {
            String line;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(countFile));
            while ((line = lineReader.readLine()) != null) {
                String[] parts = line.split("\t");
                if (parts.length != 3) continue;
                int ngramSize = Integer.valueOf(parts[0]);
                long ngramDistinctCount = Long.valueOf(parts[1]);
                long ngramCount = Long.valueOf(parts[2]);
                this.ngramCountMap.put(ngramSize, ngramCount);
                this.ngramDistinctCountMap.put(ngramSize, ngramDistinctCount);
            }
            lineReader.close();
        }
    }

    @Override
    public long getFrequency(String aPhrase) throws IOException {
        String phrase = aPhrase.trim();
        if (phrase.length() == 0) {
            return 0L;
        }
        this.logger.debug((Object)("search for : \"" + phrase + "\""));
        int ngramLevel = phrase.split("\\s+").length;
        this.logger.debug((Object)("length: " + ngramLevel));
        if (!this.ngramLevelMap.containsKey(ngramLevel)) {
            return 0L;
        }
        if (!this.ngramLevelMap.get(ngramLevel).contains(phrase)) {
            return 0L;
        }
        return this.ngramLevelMap.get(ngramLevel).getCount(phrase);
    }

    @Override
    public long getNrOfNgrams(int aNGramSize) {
        Long count = this.ngramCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }

    @Override
    public long getNrOfDistinctNgrams(int aNGramSize) {
        Long count = this.ngramDistinctCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }
}

