/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.FileMap;
import it.uniroma1.lcl.jlt.jweb1t.FileSearch;
import it.uniroma1.lcl.jlt.jweb1t.Searcher;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JWeb1TSearcher
implements Searcher {
    private final Log logger = LogFactory.getLog(JWeb1TSearcher.class);
    protected Map<Integer, FileMap> indexMap;
    private Map<Integer, Long> ngramCountMap;
    private Map<Integer, Long> ngramDistinctCountMap;

    public JWeb1TSearcher(String ... indexFiles) throws IOException {
        if (indexFiles.length > 0) {
            this.initialize(new File(indexFiles[0]).getParentFile());
        }
        this.fillIndexMap(indexFiles);
    }

    public JWeb1TSearcher(File indexPath, int minN, int maxN) throws IOException {
        this.initialize(indexPath);
        if (minN < 0 || maxN < 0 || minN > maxN) {
            throw new IOException("Wrong parameters.");
        }
        int size = maxN - minN + 1;
        String[] indexFiles = new String[size];
        int i = 0;
        while (i < size) {
            int ngramLevel = minN + i;
            indexFiles[i] = new File(indexPath, "index-" + ngramLevel + "gms").getAbsolutePath();
            ++i;
        }
        this.fillIndexMap(indexFiles);
    }

    private void initialize(File baseDir) throws NumberFormatException, IOException {
        this.ngramCountMap = new HashMap<Integer, Long>();
        this.ngramDistinctCountMap = new HashMap<Integer, Long>();
        File countFile = new File(baseDir, "aggregated_counts.cnt");
        if (countFile.exists()) {
            String line;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(countFile));
            while ((line = lineReader.readLine()) != null) {
                String[] parts = line.split("\t");
                if (parts.length != 3) continue;
                int ngramSize = Integer.valueOf(parts[0]);
                long ngramDistinctCount = Long.valueOf(parts[1]);
                long ngramCount = Long.valueOf(parts[2]);
                this.ngramCountMap.put(ngramSize, ngramCount);
                this.ngramDistinctCountMap.put(ngramSize, ngramDistinctCount);
            }
            lineReader.close();
        }
    }

    private void fillIndexMap(String[] indexFiles) throws IOException {
        this.indexMap = new HashMap<Integer, FileMap>();
        int i = 1;
        while (i <= indexFiles.length) {
            File file = new File(indexFiles[i - 1]);
            if (!file.exists()) {
                throw new IOException("Index file " + file.getPath() + " was not found");
            }
            FileMap fileMap = new FileMap(file);
            this.indexMap.put(i, fileMap);
            ++i;
        }
    }

    @Override
    public long getFrequency(String aPhrase) throws IOException {
        String phrase = aPhrase.trim();
        if (phrase.length() == 0) {
            return 0L;
        }
        this.logger.debug((Object)("search for : \"" + phrase + "\""));
        String[] tokens = phrase.split("\\s+");
        this.logger.debug((Object)("length: " + tokens.length));
        FileMap map = this.indexMap.get(tokens.length);
        if (map == null) {
            this.logger.fatal((Object)(String.valueOf(tokens.length) + "-gram index not found"));
            return 0L;
        }
        String symbol = null;
        symbol = tokens[0].length() < 2 ? tokens[0].substring(0, 1) : tokens[0].substring(0, 2);
        String[] file = map.get(symbol);
        if (file == null) {
            this.logger.warn((Object)("Could not find nGram-File for the symbol: " + symbol));
            return -1L;
        }
        StringBuilder ngram = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0) {
                ngram.append(' ');
            }
            ngram.append(tokens[i]);
            ++i;
        }
        i = 0;
        while (i < file.length) {
            this.logger.debug((Object)(String.valueOf(i) + ":" + file[i]));
            FileSearch fileSearch = new FileSearch(new File(file[i]));
            long frequency = fileSearch.getFreq(ngram.toString());
            if (frequency != 0L) {
                fileSearch.close();
                this.logger.debug((Object)("Frequency: " + frequency));
                return frequency;
            }
            fileSearch.close();
            ++i;
        }
        this.logger.debug((Object)"Frequency: 0");
        return 0L;
    }

    @Override
    public long getNrOfNgrams(int aNGramSize) {
        Long count = this.ngramCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }

    @Override
    public long getNrOfDistinctNgrams(int aNGramSize) {
        Long count = this.ngramDistinctCountMap.get(aNGramSize);
        return count == null ? -1L : count;
    }
}

