/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import bak.pcj.map.ObjectKeyLongMap;
import bak.pcj.map.ObjectKeyLongOpenHashMap;
import java.util.Set;

public class FrequencyDistribution<T> {
    private ObjectKeyLongMap freqDist = new ObjectKeyLongOpenHashMap();
    private long total = 0L;

    public FrequencyDistribution() {
    }

    public FrequencyDistribution(Iterable<T> aIterable) {
        this();
        this.incAll(aIterable);
    }

    public boolean contains(T aSample) {
        return this.freqDist.containsKey(aSample);
    }

    public void inc(T aSample) {
        this.addSample(aSample, 1L);
    }

    public void incAll(Iterable<T> aIterable) {
        for (T sample : aIterable) {
            this.addSample(sample, 1L);
        }
    }

    public long getN() {
        return this.total;
    }

    public long getB() {
        return this.freqDist.size();
    }

    public long getCount(T aSample) {
        if (this.freqDist.containsKey(aSample)) {
            return this.freqDist.get(aSample);
        }
        return 0L;
    }

    public Set<T> getKeys() {
        return this.freqDist.keySet();
    }

    public void addSample(T aSample, long aNumber) {
        this.total += aNumber;
        if (this.freqDist.containsKey(aSample)) {
            this.freqDist.put(aSample, this.freqDist.get(aSample) + aNumber);
        } else {
            this.freqDist.put(aSample, aNumber);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object o : this.freqDist.keySet()) {
            buffer.append(String.valueOf(o));
            buffer.append(" - ");
            buffer.append(this.freqDist.get(o));
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }
}

