/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.NGram;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSearch {
    protected final RandomAccessFile raf;
    private static final int MAX_LINE_LENGTH = 100;

    public FileSearch(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFreq(String aSymbol) throws IOException {
        long s = 0L;
        long m = this.raf.length();
        long e = this.raf.length();
        while (e > s + 1L) {
            m = s + (e - s) / 2L;
            NGram n = this.read(m);
            if (n == null) {
                return 0L;
            }
            int c = aSymbol.compareTo(n.symbol);
            if (c == 0) {
                return n.frequency;
            }
            if (c > 0) {
                s = m;
                continue;
            }
            e = m;
        }
        return 0L;
    }

    public NGram read(long m) throws IOException {
        long e;
        long s = m - 100L;
        if (s < 0L) {
            s = 0L;
        }
        if ((e = m + 100L) > this.raf.length()) {
            e = this.raf.length();
        }
        int len = (int)(e - s);
        int nm = (int)(m - s);
        this.raf.seek(s);
        byte[] array = new byte[len];
        this.raf.read(array);
        int i = nm;
        while (i >= 0 && (char)array[i] != '\n') {
            --i;
        }
        int ns = i + 1;
        i = nm + 1;
        while (i < array.length && (char)array[i] != '\n') {
            ++i;
        }
        int ne = i;
        byte[] curLine = new byte[ne - ns];
        int index = 0;
        int j = ns;
        while (j < ne) {
            curLine[index++] = array[j];
            ++j;
        }
        String lineAsString = new String(curLine, "UTF-8");
        if (lineAsString.length() == 0) {
            return null;
        }
        return new NGram(lineAsString);
    }
}

