/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class FileMap {
    private static final String LF = System.getProperty("line.separator");
    private final Map<String, String[]> map;
    private final File indexFile;

    public FileMap(File aIndexFile) throws IOException {
        this.indexFile = aIndexFile;
        this.map = new HashMap<String, String[]>();
        this.read(aIndexFile);
    }

    private void read(File aFile) throws IOException {
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(aFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                String[] s = line.split("\t");
                String[] t = new String[s.length - 1];
                System.arraycopy(s, 1, t, 0, t.length);
                int i = 0;
                while (i < t.length) {
                    t[i] = new File(this.indexFile.getParent(), t[i]).getAbsolutePath();
                    ++i;
                }
                this.map.put(s[0], t);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    public String[] get(String ch) {
        return this.map.get(ch);
    }

    public static int main(String[] args) throws IOException {
        String logConfig = System.getProperty("log-config");
        if (logConfig == null) {
            logConfig = "log-config.txt";
        }
        if (args.length != 2) {
            System.out.println("java PACKAGE.FileMap index-file char");
            return -1;
        }
        String ch = args[1].substring(0, 1);
        FileMap map = new FileMap(new File(args[0]));
        String[] s = map.get(ch);
        System.out.print("\"" + ch + "\"\t");
        int i = 0;
        while (i < s.length) {
            if (i > 0) {
                System.out.print(" ");
            }
            System.out.print(s[i]);
            ++i;
        }
        System.out.print("\n");
        return 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String key : this.map.keySet()) {
            buffer.append(key);
            buffer.append(" - ");
            buffer.append(StringUtils.join((Object[])this.map.get(key), (String)","));
            buffer.append(LF);
        }
        buffer.append(LF);
        return buffer.toString();
    }
}

