/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.EnhancedFileSearch;
import it.uniroma1.lcl.jlt.jweb1t.FileMap;
import it.uniroma1.lcl.jlt.jweb1t.JWeb1TSearcher;
import it.uniroma1.lcl.jlt.util.LongCounter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnhancedJWeb1TSearcher
extends JWeb1TSearcher {
    private final Log logger = LogFactory.getLog(JWeb1TSearcher.class);

    public EnhancedJWeb1TSearcher(File indexPath, int minN, int maxN) throws IOException {
        super(indexPath, minN, maxN);
    }

    public LongCounter<String> getAllMatchingNgrams(String query) throws IOException {
        return this.getAllMatchingNgrams(query, false);
    }

    public LongCounter<String> getAllMatchingNgrams(String query, boolean caseSensitive) throws IOException {
        String phrase = query.trim();
        if (phrase.length() == 0) {
            return null;
        }
        this.logger.debug((Object)("search for : \"" + phrase + "\""));
        String[] tokens = phrase.split("\\s+");
        this.logger.debug((Object)("length: " + tokens.length));
        FileMap map = (FileMap)this.indexMap.get(tokens.length);
        if (map == null) {
            this.logger.fatal((Object)(String.valueOf(tokens.length) + "-gram index not found"));
            return null;
        }
        String symbol = tokens[0].substring(0, Math.min(tokens[0].length(), 2));
        HashSet<String> files = new HashSet<String>();
        if (caseSensitive) {
            files.addAll(Arrays.asList(map.get(symbol)));
        } else {
            files.addAll(Arrays.asList(map.get(symbol)));
            files.addAll(Arrays.asList(map.get(symbol.toLowerCase())));
            files.addAll(Arrays.asList(map.get(symbol.toUpperCase())));
        }
        this.logger.info((Object)("Number of files: " + files.size()));
        if (files.isEmpty()) {
            this.logger.warn((Object)("Could not find nGram-File for the symbol: " + symbol));
            return null;
        }
        StringBuilder ngram = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0) {
                ngram.append(' ');
            }
            ngram.append(tokens[i]);
            ++i;
        }
        LongCounter<String> resultMap = new LongCounter<String>();
        for (String file : files) {
            this.logger.info((Object)("Opening file: " + file));
            EnhancedFileSearch fileSearch = new EnhancedFileSearch(new File(file));
            LongCounter<String> fileResultMap = fileSearch.getAllMatchingNgrams(ngram.toString(), caseSensitive);
            fileSearch.close();
            for (String key : fileResultMap.keySet()) {
                Long count = (Long)resultMap.get(key);
                if (count == null) {
                    count = 0L;
                }
                count = count + (Long)fileResultMap.get(key);
                resultMap.count(key, count);
            }
        }
        return resultMap;
    }
}

