/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.FileSearch;
import it.uniroma1.lcl.jlt.jweb1t.NGram;
import it.uniroma1.lcl.jlt.util.LongCounter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnhancedFileSearch
extends FileSearch {
    private final Log logger = LogFactory.getLog(EnhancedFileSearch.class);

    public EnhancedFileSearch(File file) throws IOException {
        super(file);
    }

    public LongCounter<String> getAllMatchingNgrams(String query) throws IOException {
        return this.getAllMatchingNgrams(query, false);
    }

    public LongCounter<String> getAllMatchingNgrams(String query, boolean caseSensitive) throws IOException {
        if (!caseSensitive) {
            query = query.toLowerCase();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        this.findMatchingNGrams(query, map, caseSensitive);
        return new LongCounter<String>((Map<String, Long>)map);
    }

    public void findMatchingNGrams(String query, HashMap<String, Long> map, boolean caseSensitive) throws IOException {
        long s = 0L;
        long m = this.raf.length();
        long e = this.raf.length();
        int starSymbol = -1;
        String[] queryWords = query.split("\\s+");
        int i = 0;
        while (i < queryWords.length) {
            if (queryWords[i].equals(".*")) {
                starSymbol = i;
            }
            ++i;
        }
        this.findMatchingNGrams(query, map, s, m, e, starSymbol, caseSensitive);
    }

    public void findMatchingNGrams(String query, HashMap<String, Long> map, long s, long m, long e, int starSymbol, boolean caseSensitive) throws IOException {
        if (e <= s + 1L) {
            return;
        }
        m = s + (e - s) / 2L;
        NGram n = this.read(m);
        if (n == null) {
            return;
        }
        String ngram = n.symbol;
        if (!caseSensitive) {
            ngram = ngram.toLowerCase();
        }
        boolean count = false;
        int c = 0;
        boolean match = ngram.matches(query);
        if (match) {
            this.logger.debug((Object)("Matching ngram: " + ngram));
            c = 0;
            count = true;
        } else {
            String[] queryWords = query.split("\\s+");
            String[] nWords = ngram.split("\\s+");
            queryWords[starSymbol] = nWords[starSymbol];
            int i = 0;
            while (c == 0) {
                if (i == starSymbol) {
                    c = 0;
                    break;
                }
                c = queryWords[i].compareTo(nWords[i]);
                ++i;
            }
        }
        if (c == 0) {
            if (count) {
                map.put(n.symbol, n.frequency);
            }
            this.findMatchingNGrams(query, map, m, m, e, starSymbol, caseSensitive);
            this.findMatchingNGrams(query, map, s, m, m, starSymbol, caseSensitive);
        } else if (c > 0) {
            this.findMatchingNGrams(query, map, m, m, e, starSymbol, caseSensitive);
        } else {
            this.findMatchingNGrams(query, map, s, m, m, starSymbol, caseSensitive);
        }
    }
}

