/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jweb1t;

import it.uniroma1.lcl.jlt.jweb1t.FolderScanner;
import it.uniroma1.lcl.jlt.jweb1t.IndexFilter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class AggregatedCountsCreator {
    private long aggregatedNGramCount = 0L;
    private long nrOfDifferentNGrams = 0L;

    public AggregatedCountsCreator(File aBaseDir, String aNGramSize) throws IOException {
        File ngramFile = new File(aBaseDir + "/" + aNGramSize + "gms/");
        if (ngramFile.isFile()) {
            this.read(ngramFile);
        } else {
            FolderScanner scanner = new FolderScanner(ngramFile);
            scanner.setFilter(new IndexFilter());
            while (scanner.hasNext()) {
                File[] fileArray = scanner.next();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.read(file);
                    ++n2;
                }
            }
        }
    }

    private void read(File aFile) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new FileReader(aFile));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts.length != 2) continue;
            ++this.nrOfDifferentNGrams;
            this.aggregatedNGramCount += Long.valueOf(parts[1]).longValue();
        }
        reader.close();
    }

    public long getAggregatedNGramCount() {
        return this.aggregatedNGramCount;
    }

    public long getNrOfDifferentNGrams() {
        return this.nrOfDifferentNGrams;
    }
}

