/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import it.uniroma1.lcl.jlt.jgrapht.LabeledEdge;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class WeightedLabeledEdge
extends LabeledEdge
implements Comparable<WeightedLabeledEdge> {
    private static final long serialVersionUID = -8413589259148598734L;
    private static NumberFormat NUMBER_FORMAT = DecimalFormat.getInstance(Locale.US);
    private final Double weight;

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(5);
    }

    public WeightedLabeledEdge(String label, double weight) {
        super(label);
        this.weight = weight;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("(").append(this.getSource()).append(":").append(this.label).append("[").append(NUMBER_FORMAT.format(this.weight)).append("]").append(":").append(this.getTarget()).append(")").toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.weight.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WeightedLabeledEdge) {
            WeightedLabeledEdge other = (WeightedLabeledEdge)obj;
            return super.equals(obj) && this.weight.equals(other.getWeight());
        }
        return false;
    }

    @Override
    public int compareTo(WeightedLabeledEdge e) {
        if (this.weight > e.getWeight()) {
            return 1;
        }
        if (this.weight.doubleValue() == e.getWeight()) {
            return 0;
        }
        return -1;
    }

    public Object getSource() {
        return super.getSource();
    }

    public Object getTarget() {
        return super.getTarget();
    }

    public double getWeight() {
        return this.weight;
    }
}

