/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.util.Maps;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SynsetWeightMap {
    private Map<ISynset, Double> weights = new HashMap<ISynset, Double>();
    private Map<String, Double> wordWeights = new HashMap<String, Double>();

    public SynsetWeightMap(String filename) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            WordNet wn = WordNet.getInstance();
            while (br.ready()) {
                String line = br.readLine();
                String[] pair = line.split("\t");
                String word = pair[0];
                double weight = 0.0;
                try {
                    weight = Double.parseDouble(pair[1]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("ERROR IN FILE = " + filename + ", LINE = " + line);
                    System.exit(1);
                }
                if (weight <= 3.0) continue;
                this.wordWeights.put(word, weight);
                for (IWord sense : wn.getSenses(word, POS.NOUN)) {
                    ISynset synset = sense.getSynset();
                    Double prevWeight = this.weights.get(synset);
                    if (prevWeight == null) {
                        prevWeight = 0.0;
                    }
                    this.weights.put(synset, weight + prevWeight);
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public double getWeight(ISynset s) {
        Double w = this.weights.get(s);
        if (w == null) {
            return 0.0;
        }
        return w;
    }

    public Map<ISynset, Double> getMap() {
        return this.weights;
    }

    public Set<ISynset> getSortedSynsets() {
        return Maps.sortByValue(this.weights, Maps.SortingOrder.DESCENDING).keySet();
    }

    public Set<String> getSortedWords() {
        return Maps.sortByValue(this.wordWeights, Maps.SortingOrder.DESCENDING).keySet();
    }

    public void setWeight(ISynset negativeSynset, double w) {
        this.weights.put(negativeSynset, w);
    }

    public Double getWordWeight(String lemma) {
        return this.wordWeights.get(lemma);
    }
}

