/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.jgrapht.SynsetWeightMap;
import it.uniroma1.lcl.jlt.jgrapht.WordNetGraph;
import it.uniroma1.lcl.jlt.util.Maps;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonoToPolyExtractor {
    private static final Log log = LogFactory.getLog(MonoToPolyExtractor.class);
    private WordNetGraph wordNetGraph;
    private SynsetWeightMap weights;
    private String domainName;
    private Set<ISynset> positiveSynsets = new HashSet<ISynset>();
    public static final double threshold = 0.1;
    private Set<String> done = new HashSet<String>();

    public MonoToPolyExtractor(String filename) {
        this.domainName = filename.substring(0, filename.indexOf("."));
        System.out.println(" == " + filename + " ==");
        log.info((Object)"Loading WordNet graph...");
        this.wordNetGraph = new WordNetGraph();
        System.out.println("SIZE = " + this.wordNetGraph.vertexSet().size());
        log.info((Object)"Loading weights...");
        this.weights = new SynsetWeightMap("TFIDF/" + filename);
    }

    public void run() {
        NumberFormat nf = DecimalFormat.getInstance(Locale.UK);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        WordNet wn = WordNet.getInstance();
        HashSet<ISynset> monoSynsets = new HashSet<ISynset>();
        for (String lemma : this.weights.getSortedWords()) {
            List<IWord> senses = wn.getSenses(lemma, POS.NOUN);
            if (senses.size() != 1) continue;
            monoSynsets.add(senses.get(0).getSynset());
        }
        for (String lemma : this.weights.getSortedWords()) {
            System.out.println("ANALYZING " + lemma + " (weight = " + this.weights.getWordWeight(lemma) + ")");
            if (this.done.contains(lemma)) {
                System.out.println("Already done: SKIPPING");
                System.out.println("-------------------------");
                continue;
            }
            double bestScore = 0.0;
            ISynset bestSynset = null;
            List<IWord> senses = wn.getSenses(lemma, POS.NOUN);
            if (senses.size() == 1) continue;
            for (IWord sense : senses) {
                HashSet<ISynset> matches = new HashSet<ISynset>();
                ISynset synset = sense.getSynset();
                int h = wn.getHeight(sense);
                if (h <= 3) {
                    System.out.println("SKIPPING " + wn.synsetToSenseString(lemma, synset) + " (HEIGHT = " + h + ")");
                    continue;
                }
                Set<ISynset> desc = wn.getDescendants(synset);
                if (desc.size() > 100) {
                    System.out.println("SKIPPING " + wn.synsetToSenseString(lemma, synset) + " (TOO MANY DESC = " + desc.size() + ")");
                    continue;
                }
                if (!this.wordNetGraph.containsVertex(synset)) {
                    System.out.println("GRAPH DOES NOT CONTAIN " + wn.synsetToSenseString(lemma, synset));
                    continue;
                }
                for (ISynset d : desc) {
                    if (!monoSynsets.contains(d)) continue;
                    matches.add(d);
                }
                double score = matches.size();
                System.out.println("  " + score + ":" + wn.synsetToSenseString(lemma, synset));
                if (matches.size() > 0) {
                    System.out.println("  MATCHES = " + ((Object)matches).toString());
                }
                if (!(bestScore < score)) continue;
                bestScore = score;
                bestSynset = synset;
            }
            if (bestScore > 0.0) {
                System.out.println("BEST = " + wn.synsetToSenseString(lemma, bestSynset));
                System.out.println("  SCORE = " + bestScore);
                this.positiveSynsets.add(bestSynset);
            }
            System.out.println("-------------------------");
        }
        for (ISynset positiveSynset : this.positiveSynsets) {
            System.out.println("POS = " + wn.synsetToSenseString(positiveSynset));
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".senses.txt"));
            BufferedWriter bw2 = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".trees.txt"));
            BufferedWriter bw3 = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".csv.ext1"));
            BufferedWriter bw4 = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".csv.ext2"));
            Map<ISynset, Double> treeScore = new HashMap();
            Map<ISynset, Double> senseScore = new HashMap();
            for (ISynset positiveSynset : this.positiveSynsets) {
                senseScore.put(positiveSynset, this.weights.getWeight(positiveSynset));
                double score = 0.0;
                for (ISynset d : wn.getDescendants(positiveSynset)) {
                    score += this.weights.getWeight(d);
                }
                treeScore.put(positiveSynset, score);
            }
            senseScore = Maps.sortByValue(senseScore, Maps.SortingOrder.DESCENDING);
            bw.write("# synset TFIDF\n");
            for (ISynset s : senseScore.keySet()) {
                bw.write(String.valueOf(wn.synsetToSenseString(s)) + "\t" + this.weights.getWeight(s));
                bw.write("\n");
            }
            treeScore = Maps.sortByValue(treeScore, Maps.SortingOrder.DESCENDING);
            bw2.write("# number_of_descendants synset_TFIDF tree_TF_IDF_sum root_synset\n");
            int count = 0;
            for (ISynset s : treeScore.keySet()) {
                if (++count <= 3) {
                    HashSet<String> words = new HashSet<String>();
                    words.addAll(wn.getSynsetWords(s));
                    for (ISynset d : wn.getDescendants(s)) {
                        words.addAll(wn.getSynsetWords(d));
                    }
                    for (String w : words) {
                        bw3.write(String.valueOf(w) + "\t" + treeScore.get(s));
                        bw3.write("\n");
                        bw4.write(String.valueOf(w) + "\t" + this.weights.getWeight(s));
                        bw4.write("\n");
                    }
                }
                int size = wn.getDescendants(s).size();
                bw2.write(String.valueOf(size) + "\t" + this.weights.getWeight(s) + "\t" + treeScore.get(s) + "\t" + wn.synsetToSenseString(s));
                bw2.write("\n");
            }
            bw.close();
            bw2.close();
            bw3.close();
            bw4.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\n\n");
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray = new File("TFIDF").list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.endsWith("csv")) {
                System.out.println(filename);
                new MonoToPolyExtractor(filename).run();
            }
            ++n2;
        }
    }
}

