/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.uniroma1.lcl.jlt.graphviz.DotOptions;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Maps;
import it.uniroma1.lcl.jlt.util.Pair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.Subgraph;

public class Graphs {
    public static <V, E> UndirectedGraph<V, E> getUndirectedGraph(Graph<V, E> graph) {
        Class<?> edgeClass;
        if (graph instanceof UndirectedGraph) {
            return (UndirectedGraph)graph;
        }
        Class<?> clazz = edgeClass = graph.edgeSet().size() > 0 ? graph.edgeSet().iterator().next().getClass() : null;
        if (edgeClass == null) {
            return null;
        }
        SimpleGraph undirected = new SimpleGraph(edgeClass);
        org.jgrapht.Graphs.addAllVertices((Graph)undirected, (Collection)graph.vertexSet());
        org.jgrapht.Graphs.addAllEdges((Graph)undirected, graph, (Collection)graph.edgeSet());
        return undirected;
    }

    public static <V> DefaultDirectedWeightedGraph<V, DefaultWeightedEdge> convertGraphToWeightedGraph(DefaultDirectedWeightedGraph<V, DefaultEdge> g, double defaultWeight) {
        DefaultDirectedWeightedGraph weightedG = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
        for (Object v : g.vertexSet()) {
            weightedG.addVertex(v);
        }
        for (DefaultEdge de : g.edgeSet()) {
            Object edgeSource = g.getEdgeSource((Object)de);
            Object edgeTarget = g.getEdgeTarget((Object)de);
            DefaultWeightedEdge dwe = (DefaultWeightedEdge)weightedG.addEdge(edgeSource, edgeTarget);
            weightedG.setEdgeWeight((Object)dwe, defaultWeight);
        }
        return weightedG;
    }

    public static <V> DefaultDirectedWeightedGraph<V, DefaultEdge> convertGraphFromWeightedGraph(DefaultDirectedWeightedGraph<V, DefaultWeightedEdge> g) {
        DefaultDirectedWeightedGraph result = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        for (Object v : g.vertexSet()) {
            result.addVertex(v);
        }
        for (DefaultWeightedEdge de : g.edgeSet()) {
            Object edgeSource = g.getEdgeSource((Object)de);
            Object edgeTarget = g.getEdgeTarget((Object)de);
            result.addEdge(edgeSource, edgeTarget);
        }
        return result;
    }

    public static <V> DefaultDirectedWeightedGraph<V, DefaultWeightedEdge> convertGraphToWeightedGraphInverted(DefaultDirectedWeightedGraph<V, DefaultEdge> g1, Map<DefaultEdge, Double> weights) {
        DefaultDirectedWeightedGraph result = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
        for (DefaultEdge de : g1.edgeSet()) {
            Object edgeSource = g1.getEdgeSource((Object)de);
            Object edgeTarget = g1.getEdgeTarget((Object)de);
            result.addVertex(edgeSource);
            result.addVertex(edgeTarget);
            DefaultWeightedEdge dwe = (DefaultWeightedEdge)result.addEdge(edgeTarget, edgeSource);
            result.setEdgeWeight((Object)dwe, weights.get(de).doubleValue());
        }
        return result;
    }

    public static <V, E> Multimap<Integer, V> visitConnectedComponents(DefaultDirectedGraph<V, E> g) {
        HashMultimap map = new HashMultimap();
        HashSet visited = new HashSet();
        int componentNo = 0;
        for (Object v : g.vertexSet()) {
            if (visited.contains(v)) continue;
            Graphs.DFS(g, v, visited, map, ++componentNo);
        }
        return map;
    }

    private static <V, E> void DFS(DefaultDirectedGraph<V, E> g, V v, Set<V> visited, Multimap<Integer, V> map, int componentNo) {
        if (visited.contains(v)) {
            return;
        }
        visited.add(v);
        map.put((Object)componentNo, v);
        for (Object s : org.jgrapht.Graphs.successorListOf(g, v)) {
            Graphs.DFS(g, s, visited, map, componentNo);
        }
    }

    public static <V, E> void removeIncomingEdges(DefaultDirectedWeightedGraph<V, E> g, V node) {
        Set edgesOnNode = g.edgesOf(node);
        for (Object de : edgesOnNode) {
            if (!g.getEdgeTarget(de).equals(node)) continue;
            g.removeEdge(de);
        }
    }

    public static <V, E> DefaultDirectedWeightedGraph<V, E> getInvertedDirectedGraph(DefaultDirectedWeightedGraph<V, E> g, Class<? extends E> edgeclass) {
        DefaultDirectedWeightedGraph invertedG = new DefaultDirectedWeightedGraph(edgeclass);
        for (Object v : g.vertexSet()) {
            invertedG.addVertex(v);
        }
        for (Object de : g.edgeSet()) {
            Object source = g.getEdgeSource(de);
            Object target = g.getEdgeTarget(de);
            invertedG.addEdge(target, source);
        }
        return invertedG;
    }

    public static <V, E> void removeDisconnectedVertices(Graph<V, E> graph) {
        for (Object v : new HashSet(graph.vertexSet())) {
            if (graph.edgesOf(v).size() != 0) continue;
            graph.removeVertex(v);
        }
    }

    public static <V, E> Set<V> getRoots(DefaultDirectedGraph<V, E> g, Set<V> componentNodes) {
        HashSet<V> roots = new HashSet<V>();
        for (V v : componentNodes) {
            if (g.inDegreeOf(v) != 0) continue;
            roots.add(v);
        }
        return roots;
    }

    public static <V, E> DirectedGraph<V, E> unionGraphDirected(Collection<Graph<V, E>> graphs, Class<E> edgeClass) {
        DefaultDirectedGraph union = new DefaultDirectedGraph(edgeClass);
        for (Graph<V, E> graph : graphs) {
            org.jgrapht.Graphs.addGraph((Graph)union, graph);
        }
        return union;
    }

    public static <V, E> Graph<V, E> unionGraphSimple(Collection<Graph<V, E>> graphs, Class<E> edgeClass) {
        SimpleGraph union = new SimpleGraph(edgeClass);
        for (Graph<V, E> graph : graphs) {
            org.jgrapht.Graphs.addGraph((Graph)union, graph);
        }
        return union;
    }

    public static <V, E> int calculateNodeWeights(DefaultDirectedGraph<V, E> g, V v, Set<V> relevantNodes, int relevantNodeNumber, Set<V> visited) {
        if (visited.contains(v)) {
            return relevantNodeNumber;
        }
        HashSet<V> newVisited = new HashSet<V>(visited);
        newVisited.add(v);
        for (Object e : g.outgoingEdgesOf(v)) {
            Object u = g.getEdgeTarget(e);
            relevantNodeNumber += Graphs.calculateNodeWeights(g, u, relevantNodes, relevantNodeNumber, newVisited);
        }
        return relevantNodeNumber + (relevantNodes.contains(v) ? 1 : 0);
    }

    public static <V, E> Map<V, Double> getNodeWeights(DefaultDirectedGraph<V, E> g, Set<V> component, Set<V> relevantNodes) {
        HashMap<V, Double> weightedNodes = new HashMap<V, Double>();
        for (V v : component) {
            int relevantNodeNumber = Graphs.calculateNodeWeights(g, v, relevantNodes, 0, new HashSet());
            weightedNodes.put(v, Double.valueOf(relevantNodeNumber));
        }
        return weightedNodes;
    }

    public static <V, E> void copyGraph(Graph<V, E> source, Graph<V, E> target) {
        boolean bWeighted = source instanceof DefaultDirectedWeightedGraph && target instanceof DefaultDirectedWeightedGraph;
        for (Object v : source.vertexSet()) {
            target.addVertex(v);
        }
        for (Object sourceEdge : source.edgeSet()) {
            Object targetEdge = target.addEdge(source.getEdgeSource(sourceEdge), target.getEdgeTarget(sourceEdge));
            if (!bWeighted) continue;
            ((DefaultDirectedWeightedGraph)target).setEdgeWeight(targetEdge, source.getEdgeWeight(sourceEdge));
        }
    }

    public static <V, E> DefaultDirectedWeightedGraph<V, E> getDirectedGraphWithOneRootPerComponent(DefaultDirectedWeightedGraph<V, E> g, Set<V> relevantNodes, Set<V> goodPotentialRoots) {
        boolean bFinito;
        Class<?> edgeClass;
        Class<?> clazz = edgeClass = g.edgeSet().size() > 0 ? g.edgeSet().iterator().next().getClass() : null;
        if (edgeClass == null) {
            return g;
        }
        DefaultDirectedWeightedGraph newG = new DefaultDirectedWeightedGraph(edgeClass);
        Graphs.copyGraph(g, newG);
        block0: do {
            bFinito = true;
            ConnectivityInspector inspector = new ConnectivityInspector((DirectedGraph)newG);
            for (Set component : inspector.connectedSets()) {
                Map<V, Double> weightedNodes;
                HashSet<V> potentialRoots;
                Object newRoot;
                Set<V> roots = Graphs.getRoots(newG, component);
                if (roots.size() == 1) continue;
                if (roots.size() == 0) {
                    bFinito = false;
                    newRoot = null;
                    potentialRoots = new HashSet<V>(goodPotentialRoots);
                    potentialRoots.retainAll(component);
                    if (potentialRoots.size() > 0) {
                        newRoot = potentialRoots.iterator().next();
                    } else {
                        weightedNodes = Graphs.getNodeWeights(newG, component, relevantNodes);
                        weightedNodes = Maps.sortByValue(weightedNodes, Maps.SortingOrder.DESCENDING);
                        newRoot = weightedNodes.keySet().iterator().next();
                    }
                    newG.removeAllEdges(new HashSet(newG.incomingEdgesOf(newRoot)));
                    continue block0;
                }
                bFinito = false;
                newRoot = null;
                potentialRoots = new HashSet<V>(goodPotentialRoots);
                potentialRoots.retainAll(roots);
                if (potentialRoots.size() > 0) {
                    newRoot = potentialRoots.iterator().next();
                } else {
                    weightedNodes = Graphs.getNodeWeights(newG, roots, relevantNodes);
                    weightedNodes = Maps.sortByValue(weightedNodes, Maps.SortingOrder.DESCENDING);
                    newRoot = weightedNodes.keySet().iterator().next();
                }
                for (V r : roots) {
                    if (r.equals(newRoot)) continue;
                    newG.removeAllEdges(new HashSet(newG.outgoingEdgesOf(r)));
                }
            }
        } while (!bFinito);
        return newG;
    }

    public static <V, E> DefaultDirectedWeightedGraph<V, E> getDirectedGraphWithOneRootPerComponent(DefaultDirectedWeightedGraph<V, E> g, Set<V> relevantNodes) {
        return Graphs.getDirectedGraphWithOneRootPerComponent(g, relevantNodes, new HashSet());
    }

    public static <V, E> DefaultDirectedWeightedGraph<V, E> getDirectedGraphWithOneRootPerComponent(DefaultDirectedWeightedGraph<V, E> g) {
        return Graphs.getDirectedGraphWithOneRootPerComponent(g, g.vertexSet(), new HashSet());
    }

    public static <V, E> Subgraph<V, E, Graph<V, E>> getSubgraphFrom(Collection<V> sources, int maxDepth, Graph<V, E> base) {
        HashSet vertexSubset = new HashSet();
        HashSet edgeSubset = new HashSet();
        for (V source : sources) {
            HashSet sourceVertexSubset = new HashSet();
            HashSet sourceEdgeSubset = new HashSet();
            Graphs.getSubgraphFrom(source, maxDepth, base, 0, sourceVertexSubset, sourceEdgeSubset);
            vertexSubset.addAll(sourceVertexSubset);
            edgeSubset.addAll(sourceEdgeSubset);
        }
        return new Subgraph(base, vertexSubset, edgeSubset);
    }

    public static <V, E> Subgraph<V, E, Graph<V, E>> getSubgraphFrom(V source, int maxDepth, Graph<V, E> base) {
        HashSet vertexSubset = new HashSet();
        HashSet edgeSubset = new HashSet();
        Graphs.getSubgraphFrom(source, maxDepth, base, 0, vertexSubset, edgeSubset);
        return new Subgraph(base, vertexSubset, edgeSubset);
    }

    private static <V, E> void getSubgraphFrom(V source, int maxDepth, Graph<V, E> base, int currentDepth, Set<V> vertexSubset, Set<E> edgeSubset) {
        if (currentDepth > maxDepth) {
            return;
        }
        if (vertexSubset.contains(source)) {
            return;
        }
        vertexSubset.add(source);
        List next = null;
        next = base instanceof DirectedGraph ? org.jgrapht.Graphs.successorListOf((DirectedGraph)((DirectedGraph)base), source) : org.jgrapht.Graphs.neighborListOf(base, source);
        for (Object target : next) {
            Object edge = base.getEdge(source, target);
            edgeSubset.add(edge);
            Graphs.getSubgraphFrom(target, maxDepth, base, currentDepth + 1, vertexSubset, edgeSubset);
        }
    }

    public static <V, E> void saveDotFile(Graph<V, E> graph, String filename) {
        Graphs.saveDotFile(graph, filename, null, null);
    }

    public static <V, E> void saveDotFile(Graph<V, E> graph, String filename, Multimap<V, Pair<DotOptions, String>> vertexOptions, Multimap<E, Pair<DotOptions, String>> edgeOptions) {
        Graphs.saveDotFile(graph, filename, vertexOptions, edgeOptions, null);
    }

    public static <V, E> void saveDotFile(Graph<V, E> graph, String filename, Multimap<V, Pair<DotOptions, String>> vertexOptions, Multimap<E, Pair<DotOptions, String>> edgeOptions, VertexNameProvider<V> vertexLabelProvider) {
        Graphs.saveDotFile(graph, filename, vertexOptions, edgeOptions, vertexLabelProvider, null);
    }

    public static <V, E> void saveDotFile(Graph<V, E> graph, String filename, Multimap<V, Pair<DotOptions, String>> vertexOptions, Multimap<E, Pair<DotOptions, String>> edgeOptions, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeLabelProvider) {
        try {
            BufferedWriter bw = Files.getBufferedWriter(filename);
            boolean bdirected = false;
            bdirected = graph instanceof Subgraph ? ((Subgraph)graph).getBase() instanceof DirectedGraph : graph instanceof DirectedGraph;
            String rel = "->";
            String head = "digraph";
            if (!bdirected) {
                rel = "--";
                head = "graph";
            }
            bw.write(String.valueOf(head) + " G { \n");
            for (Object v : graph.vertexSet()) {
                String vLabel = v.toString();
                if (vertexLabelProvider != null) {
                    vLabel = vertexLabelProvider.getVertexName(v);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("\t\"").append(vLabel).append("\"");
                if (vertexOptions != null && vertexOptions.containsKey(v)) {
                    buffer.append(" [");
                    boolean bOption = false;
                    for (Pair vertexOption : vertexOptions.get(v)) {
                        DotOptions optionType = (DotOptions)((Object)vertexOption.getFirst());
                        if (!optionType.isNodeAttribute()) continue;
                        buffer.append(((DotOptions)((Object)vertexOption.getFirst())).name().toLowerCase()).append("=\"").append((String)vertexOption.getSecond()).append("\",");
                        bOption = true;
                    }
                    if (bOption) {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                    buffer.append("]");
                }
                buffer.append(";\n");
                bw.write(buffer.toString());
            }
            for (Object e : graph.edgeSet()) {
                String vfromLabel = "";
                Object vfrom = graph.getEdgeSource(e);
                vfromLabel = vertexLabelProvider != null ? vertexLabelProvider.getVertexName(vfrom) : vfrom.toString();
                String vtoLabel = "";
                Object vto = graph.getEdgeTarget(e);
                vtoLabel = vertexLabelProvider != null ? vertexLabelProvider.getVertexName(vto) : vto.toString();
                StringBuffer buffer = new StringBuffer();
                buffer.append("\t\"").append(vfromLabel).append("\" ").append(rel).append(" \"").append(vtoLabel).append("\"").toString();
                if (edgeLabelProvider != null) {
                    buffer.append(" [label=").append(edgeLabelProvider.getEdgeName(e)).append("]");
                }
                buffer.append("\n");
                bw.write(buffer.toString());
            }
            bw.write("}");
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <V, E> void removeOutcomingEdges(DefaultDirectedWeightedGraph<V, E> g, V node) {
        HashSet edgesOnNode = new HashSet(g.outgoingEdgesOf(node));
        g.removeAllEdges(edgesOnNode);
    }

    public static <V, E> Pair<DefaultDirectedWeightedGraph<V, E>, Map<E, Double>> getInvertedDirectedGraph(DefaultDirectedWeightedGraph<V, E> g1, Class edgeclass, Map<E, Double> weights) {
        DefaultDirectedWeightedGraph resultG = new DefaultDirectedWeightedGraph(edgeclass);
        HashMap<Object, Double> resultM = new HashMap<Object, Double>();
        for (Object v : g1.vertexSet()) {
            resultG.addVertex(v);
        }
        for (Object de : g1.edgeSet()) {
            Double w = weights.get(de);
            Object source = g1.getEdgeSource(de);
            Object target = g1.getEdgeTarget(de);
            Object newE = resultG.addEdge(target, source);
            resultM.put(newE, w);
        }
        return new Pair<DefaultDirectedWeightedGraph<V, E>, Map<E, Double>>(resultG, resultM);
    }

    public static void main(String[] args) {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
        g.addVertex((Object)"a");
        g.addVertex((Object)"b");
        g.addVertex((Object)"c");
        g.addVertex((Object)"d");
        g.addVertex((Object)"e");
        g.addVertex((Object)"f");
        g.addVertex((Object)"g");
        g.addVertex((Object)"y");
        g.addVertex((Object)"z");
        g.addEdge((Object)"z", (Object)"b");
        g.addEdge((Object)"y", (Object)"b");
        g.addEdge((Object)"a", (Object)"b");
        g.addEdge((Object)"b", (Object)"c");
        g.addEdge((Object)"c", (Object)"d");
        g.addEdge((Object)"d", (Object)"e");
        g.addEdge((Object)"e", (Object)"f");
        g.addEdge((Object)"e", (Object)"g");
        g.addEdge((Object)"g", (Object)"c");
        g.addEdge((Object)"f", (Object)"g");
        DefaultWeightedEdge de = (DefaultWeightedEdge)g.addEdge((Object)"g", (Object)"a");
        g.setEdgeWeight((Object)de, 50.0);
        HashSet<String> terminology = new HashSet<String>();
        terminology.add("c");
        terminology.add("e");
        terminology.add("f");
        HashSet<String> core = new HashSet<String>();
        core.add("d");
        core.add("y");
        g = Graphs.getDirectedGraphWithOneRootPerComponent(g, terminology, core);
        Subgraph subG = Graphs.getSubgraphFrom("b", 5, g);
        HashMultimap vertexOptions = new HashMultimap();
        vertexOptions.put((Object)"a", new Pair<DotOptions, String>(DotOptions.FILLCOLOR, "red"));
        vertexOptions.put((Object)"b", new Pair<DotOptions, String>(DotOptions.FILLCOLOR, "red"));
        vertexOptions.put((Object)"b", new Pair<DotOptions, String>(DotOptions.SHAPE, "rounded_rectangle"));
        vertexOptions.put((Object)"b", new Pair<DotOptions, String>(DotOptions.SIZE, String.valueOf("a".toCharArray().length * 15)));
        vertexOptions.put((Object)"c", new Pair<DotOptions, String>(DotOptions.FILLCOLOR, "green"));
        vertexOptions.put((Object)"d", new Pair<DotOptions, String>(DotOptions.FILLCOLOR, "yellow"));
        HashMultimap edgeOptions = new HashMultimap();
        Graphs.saveDotFile(subG, "tmp/grafo00.dot", vertexOptions, edgeOptions);
        Graphs.saveDotFile(subG, "tmp/grafo01.dot", vertexOptions, edgeOptions, new StringNameProvider());
        Graphs.saveDotFile(subG, "tmp/grafo02.dot", vertexOptions, edgeOptions, new StringNameProvider(), new IntegerEdgeNameProvider());
    }
}

