/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import it.uniroma1.lcl.jlt.jgrapht.Graphs;
import it.uniroma1.lcl.jlt.util.Maths;
import java.util.HashMap;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BellmanFordShortestPath;

public enum GraphGlobalScorer {
    COMPACTNESS{

        @Override
        public <V, E> double score(Graph<V, E> graph) {
            int v = graph.vertexSet().size();
            if (v == 1) {
                return 1.0;
            }
            double min = v * (v - 1);
            double max = v * v * (v - 1);
            double sum = 0.0;
            for (Object v1 : graph.vertexSet()) {
                BellmanFordShortestPath shortest = new BellmanFordShortestPath(graph, v1);
                for (Object v2 : graph.vertexSet()) {
                    if (v2.equals(v1)) continue;
                    List shortestPath = shortest.getPathEdgeList(v2);
                    if (shortestPath != null) {
                        sum += (double)shortestPath.size();
                        continue;
                    }
                    sum += (double)v;
                }
            }
            return (max - sum) / (max - min);
        }
    }
    ,
    ENTROPY{

        @Override
        public <V, E> double score(Graph<V, E> graph) {
            UndirectedGraph<V, E> undirected = Graphs.getUndirectedGraph(graph);
            int v = graph.vertexSet().size();
            double score = v;
            if (v > 1) {
                double p;
                score = 0.0;
                double e = undirected.edgeSet().size();
                HashMap distribution = new HashMap();
                for (Object v1 : undirected.vertexSet()) {
                    p = (double)undirected.degreeOf(v1) / (2.0 * e);
                    distribution.put(v1, p);
                }
                for (Object v1 : undirected.vertexSet()) {
                    p = (Double)distribution.get(v1);
                    score += p * Maths.log2(p);
                }
                score = -score / Maths.log2(v);
            }
            return score;
        }
    }
    ,
    EDGE_DENSITY{

        @Override
        public <V, E> double score(Graph<V, E> graph) {
            UndirectedGraph<V, E> undirected = Graphs.getUndirectedGraph(graph);
            int v = graph.vertexSet().size();
            double score = v;
            if (v > 1) {
                double num = undirected.edgeSet().size();
                double den = Maths.binomial(v, 2);
                score = num / den;
            }
            return score;
        }
    };


    private GraphGlobalScorer() {
    }

    public abstract <V, E> double score(Graph<V, E> var1);

    /* synthetic */ GraphGlobalScorer(String string, int n, GraphGlobalScorer graphGlobalScorer) {
        this();
    }
}

