/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import it.uniroma1.lcl.jlt.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.Graphs;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class ForceBasedAlgorithm<V, E> {
    private static final Log log = LogFactory.getLog(ForceBasedAlgorithm.class);
    private static final double EPSILON = 1.0E-4;
    private static final double CHARGE = 1000.0;
    private static final double DAMPING = 0.8;
    private static final double HOOKE_CONSTANT = 0.1;
    private static final double SPRING_MINIMAL_LENGTH = 1.0;
    private final int minFrontierX = -100000;
    private final int minFrontierY = -100000;
    private final int maxFrontierX = 100000;
    private final int maxFrontierY = 100000;
    private Map<V, Pair<Double, Double>> velocity;
    private Map<V, Pair<Double, Double>> positions;
    private Map<V, Double> weights;
    private WeightedGraph<V, E> graph;

    public ForceBasedAlgorithm(WeightedGraph<V, E> g, Map<V, Double> weights) {
        this.graph = g;
        this.weights = weights;
        this.velocity = new HashMap<V, Pair<Double, Double>>();
        this.positions = new HashMap<V, Pair<Double, Double>>();
        Random rand = new Random();
        for (Object v : this.graph.vertexSet()) {
            this.velocity.put((Pair<Double, Double>)v, new Pair<Double, Double>(0.0, 0.0));
            this.positions.put((Pair<Double, Double>)v, new Pair<Double, Double>(rand.nextDouble(), rand.nextDouble()));
        }
    }

    public void run() {
        double kineticEnergy = 0.0;
        double lastEnergyChange = 0.0;
        int k = 0;
        do {
            log.info((Object)("ITERATION #" + ++k));
            double oldKineticEnergy = kineticEnergy;
            kineticEnergy = this.recalculateVectors();
            lastEnergyChange = Math.abs(oldKineticEnergy - kineticEnergy) / kineticEnergy;
            log.info((Object)("LAST ENERGY CHANGE = " + lastEnergyChange));
        } while (lastEnergyChange > 1.0E-4);
        for (Object e : this.graph.edgeSet()) {
            Object v1 = this.graph.getEdgeSource(e);
            Object v2 = this.graph.getEdgeTarget(e);
            Pair<Double, Double> p1 = this.positions.get(v1);
            Pair<Double, Double> p2 = this.positions.get(v2);
            double dist = Math.sqrt(Math.pow(p1.getFirst() - p2.getFirst(), 2.0) + Math.pow(p1.getSecond() - p2.getSecond(), 2.0));
            this.graph.setEdgeWeight(e, dist);
        }
    }

    private double recalculateVectors() {
        double kineticEnergy = 0.0;
        int vertexSize = this.graph.vertexSet().size();
        for (Object v : this.graph.vertexSet()) {
            double dy;
            double dx;
            double vX = this.positions.get(v).getFirst();
            double vY = this.positions.get(v).getSecond();
            Double vWeight = this.weights.get(v);
            if (vWeight == null) {
                vWeight = 0.0;
            }
            log.info((Object)v.toString());
            List neighbours = Graphs.neighborListOf(this.graph, v);
            double sumGravityFx = 0.0;
            double sumGravityFy = 0.0;
            for (Object n : this.graph.vertexSet()) {
                if (v.equals(n)) continue;
                double nX = this.positions.get(n).getFirst();
                double nY = this.positions.get(n).getSecond();
                double diff = Math.sqrt(Math.pow(vX - nX, 2.0) + Math.pow(vY - nY, 2.0));
                if (diff < (double)(2 * vertexSize)) {
                    diff = 2 * vertexSize;
                }
                if (diff == 0.0) {
                    System.out.println("DIFF = 0!");
                    System.exit(1);
                }
                double gravityF = 1.0 / Math.pow(diff, 2.0) * 1000.0;
                kineticEnergy += Math.abs(gravityF);
                double gravityFx = gravityF * (-nX + vX) / diff;
                double gravityFy = gravityF * (-nY + vY) / diff;
                sumGravityFx += gravityFx;
                sumGravityFy += gravityFy;
            }
            double sumHookeFx = 0.0;
            double sumHookeFy = 0.0;
            for (Object n : neighbours) {
                double diff;
                double nX = this.positions.get(n).getFirst();
                double nY = this.positions.get(n).getSecond();
                Double nWeight = this.weights.get(n);
                if (nWeight == null) {
                    nWeight = 0.0;
                }
                if ((diff = Math.sqrt(Math.pow(vX - nX, 2.0) + Math.pow(vY - nY, 2.0))) == 0.0) {
                    System.out.println("DIFF = 0!");
                    System.exit(1);
                }
                double hookeF = -0.1 * (diff - 1.0);
                kineticEnergy += Math.abs(hookeF);
                double hookeFx = hookeF * (-nX + vX) / diff;
                double hookeFy = hookeF * (-nY + vY) / diff;
                sumHookeFx += vWeight * nWeight * hookeFx;
                sumHookeFy += vWeight * nWeight * hookeFy;
            }
            Pair<Double, Double> oldVelocityPair = this.velocity.get(v);
            if ((vX < -100000.0 || vX > 100000.0) && (vY < -100000.0 || vY > 100000.0)) {
                dx = (oldVelocityPair.getFirst() + sumGravityFx + sumHookeFx) * Math.pow(0.8, 12.0);
                dy = (oldVelocityPair.getSecond() + sumGravityFy + sumHookeFy) * Math.pow(0.8, 12.0);
            } else if (vX < -100000.0 || vX > 100000.0) {
                dx = (oldVelocityPair.getFirst() + sumGravityFx + sumHookeFx) * Math.pow(0.8, 12.0);
                dy = (oldVelocityPair.getSecond() + sumGravityFy + sumHookeFy) * 0.8;
            } else if (vY < -100000.0 || vY > 100000.0) {
                dx = (oldVelocityPair.getFirst() + sumGravityFx + sumHookeFx) * 0.8;
                dy = (oldVelocityPair.getSecond() + sumGravityFy + sumHookeFy) * Math.pow(0.8, 12.0);
            } else {
                dx = (oldVelocityPair.getFirst() + sumGravityFx + sumHookeFx) * 0.8;
                dy = (oldVelocityPair.getSecond() + sumGravityFy + sumHookeFy) * 0.8;
            }
            this.velocity.put((Pair<Double, Double>)v, new Pair<Double, Double>(dx, dy));
            Pair<Double, Double> oldPositionPair = this.positions.get(v);
            double xPos = oldPositionPair.getFirst() + dx;
            double yPos = oldPositionPair.getSecond() + dy;
            this.positions.put((Pair<Double, Double>)v, new Pair<Double, Double>(xPos, yPos));
            log.info((Object)("VEL = " + dx + "," + dy));
            log.info((Object)("kineticEnergy = " + kineticEnergy));
        }
        return kineticEnergy;
    }

    public static void main(String[] args) {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
        g.addVertex((Object)"a");
        g.addVertex((Object)"b");
        g.addVertex((Object)"c");
        g.addVertex((Object)"d");
        g.addVertex((Object)"e");
        g.addVertex((Object)"f");
        g.addVertex((Object)"g");
        g.addVertex((Object)"h");
        g.addVertex((Object)"i");
        g.addVertex((Object)"j");
        g.addVertex((Object)"l");
        g.addVertex((Object)"m");
        g.addVertex((Object)"n");
        g.addVertex((Object)"o");
        g.addVertex((Object)"p");
        g.addVertex((Object)"q");
        g.addVertex((Object)"r");
        g.addVertex((Object)"s");
        g.addVertex((Object)"t");
        g.addVertex((Object)"u");
        g.addVertex((Object)"v");
        g.addVertex((Object)"z");
        g.addVertex((Object)"x");
        g.addVertex((Object)"y");
        g.addVertex((Object)"w");
        g.addEdge((Object)"a", (Object)"e");
        g.addEdge((Object)"b", (Object)"e");
        g.addEdge((Object)"c", (Object)"e");
        g.addEdge((Object)"d", (Object)"e");
        g.addEdge((Object)"e", (Object)"f");
        g.addEdge((Object)"f", (Object)"g");
        g.addEdge((Object)"g", (Object)"h");
        g.addEdge((Object)"h", (Object)"i");
        g.addEdge((Object)"h", (Object)"s");
        g.addEdge((Object)"h", (Object)"l");
        g.addEdge((Object)"h", (Object)"r");
        g.addEdge((Object)"l", (Object)"m");
        g.addEdge((Object)"m", (Object)"n");
        g.addEdge((Object)"m", (Object)"o");
        g.addEdge((Object)"m", (Object)"p");
        g.addEdge((Object)"m", (Object)"q");
        g.addEdge((Object)"s", (Object)"x");
        g.addEdge((Object)"x", (Object)"v");
        g.addEdge((Object)"v", (Object)"z");
        g.addEdge((Object)"v", (Object)"u");
        g.addEdge((Object)"v", (Object)"t");
        g.addEdge((Object)"x", (Object)"y");
        g.addEdge((Object)"y", (Object)"w");
        g.addEdge((Object)"y", (Object)"j");
        HashMap<String, Double> weights = new HashMap<String, Double>();
        weights.put("a", 0.2);
        weights.put("b", 0.1);
        weights.put("c", 1.0);
        weights.put("d", 1.0);
        weights.put("e", 1.0);
        weights.put("f", 0.2);
        weights.put("g", 1.0);
        weights.put("h", 1.0);
        weights.put("i", 1.0);
        weights.put("l", 1.0);
        weights.put("m", 1.0);
        weights.put("n", 1.0);
        weights.put("o", 1.0);
        weights.put("p", 1.0);
        weights.put("q", 1.0);
        weights.put("r", 1.0);
        weights.put("s", 1.0);
        weights.put("t", 1.0);
        weights.put("u", 1.0);
        weights.put("v", 1.0);
        weights.put("z", 1.0);
        weights.put("y", 1.0);
        weights.put("x", 1.0);
        weights.put("w", 1.0);
        weights.put("j", 1.0);
        new ForceBasedAlgorithm(g, weights).run();
    }
}

