/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import it.uniroma1.lcl.jlt.jgrapht.Graphs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.alg.DirectedNeighborIndex;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class EdmondsAlgorithm<V, E> {
    private static final Log log = LogFactory.getLog(EdmondsAlgorithm.class);
    private DefaultDirectedWeightedGraph<V, E> T;

    public List<V> getCycle(DefaultDirectedWeightedGraph<V, E> g) {
        HashSet visited = new HashSet();
        List cycle = null;
        for (Object v : g.vertexSet()) {
            if (visited.contains(v) || (cycle = this.getCycle(v, g, visited)) == null) continue;
            return cycle;
        }
        return null;
    }

    public DefaultDirectedWeightedGraph<V, E> getOptimumBranching(DefaultDirectedWeightedGraph<V, E> g, Weighting weighting) {
        HashSet roots = new HashSet(g.vertexSet());
        for (Object e : g.edgeSet()) {
            roots.remove(g.getEdgeTarget(e));
        }
        if (roots.size() == 0) {
            g = Graphs.getDirectedGraphWithOneRootPerComponent(g);
        }
        log.info((Object)("ROOTS = " + roots));
        for (Object root : roots) {
            g = this.getOptimumBranching(g, root, weighting);
        }
        return g;
    }

    public DefaultDirectedWeightedGraph<V, E> getOptimumBranching(DefaultDirectedWeightedGraph<V, E> g, V root, Weighting weighting) {
        this.T = this.getInitialTree(root, g, weighting);
        this.contractAndExpand(root, g, weighting);
        return this.T;
    }

    private DefaultDirectedWeightedGraph<V, E> contractAndExpand(V root, DefaultDirectedWeightedGraph<V, E> g, Weighting weighting) {
        log.debug((Object)("Tree iniziale: " + this.T));
        List<V> cycle = this.getCycle(this.T);
        if (cycle == null) {
            return this.T;
        }
        log.debug((Object)("CYCLE = " + cycle));
        this.T = this.contract(this.T, cycle, weighting);
        this.contractAndExpand(root, g, weighting);
        this.expand(g, cycle, weighting);
        log.debug((Object)("Tree finale: " + this.T));
        return this.T;
    }

    private DefaultDirectedWeightedGraph<V, E> getInitialTree(V root, DefaultDirectedWeightedGraph<V, E> g, Weighting weighting) {
        DefaultDirectedWeightedGraph newG = new DefaultDirectedWeightedGraph(g.getEdgeFactory());
        DirectedNeighborIndex ni = new DirectedNeighborIndex(g);
        for (Object v : g.vertexSet()) {
            List inVertices;
            newG.addVertex(v);
            if (v == root || (inVertices = ni.predecessorListOf(v)).isEmpty()) continue;
            double minWeight = weighting == Weighting.MAX ? -1.7976931348623157E308 : Double.MAX_VALUE;
            Object min = null;
            for (Object p : inVertices) {
                Object edge = g.getEdge(p, v);
                double edgeWeight = g.getEdgeWeight(edge);
                if (!(weighting == Weighting.MIN ? edgeWeight < minWeight : edgeWeight > minWeight)) continue;
                minWeight = edgeWeight;
                min = p;
            }
            newG.addVertex(min);
            Object edge = newG.addEdge(min, v);
            newG.setEdgeWeight(edge, minWeight);
        }
        return newG;
    }

    private DefaultDirectedWeightedGraph<V, E> contract(DefaultDirectedWeightedGraph<V, E> g, List<V> cycle, Weighting weighting) {
        DirectedNeighborIndex ni = new DirectedNeighborIndex(g);
        Iterator minVertex1 = null;
        double minWeight = weighting == Weighting.MAX ? -1.7976931348623157E308 : Double.MAX_VALUE;
        for (V j : cycle) {
            for (Iterator i : ni.predecessorListOf(j)) {
                if (cycle.contains(i)) continue;
                int idx = cycle.lastIndexOf(j);
                V k = cycle.get(idx - 1);
                Object ek_j = g.getEdge(k, j);
                Object ei_j = g.getEdge(i, j);
                double wi_j = g.getEdgeWeight(ei_j) - g.getEdgeWeight(ek_j);
                if (weighting == Weighting.MIN ? minWeight > wi_j : minWeight < wi_j) {
                    minWeight = wi_j;
                    minVertex1 = i;
                }
                g.setEdgeWeight(ei_j, wi_j);
            }
        }
        DefaultDirectedWeightedGraph newG = new DefaultDirectedWeightedGraph(g.getEdgeFactory());
        for (Object v : g.vertexSet()) {
            newG.addVertex(v);
        }
        for (Object e : g.edgeSet()) {
            Object v1 = g.getEdgeSource(e);
            Object v2 = g.getEdgeTarget(e);
            Object eC = newG.addEdge(v1, v2);
            newG.setEdgeWeight(eC, g.getEdgeWeight(e));
        }
        V pseudoVertex = cycle.get(0);
        for (Object v : cycle) {
            newG.removeVertex(v);
        }
        newG.addVertex(pseudoVertex);
        if (minVertex1 != null) {
            Object minEdge = newG.addEdge(minVertex1, pseudoVertex);
            newG.setEdgeWeight(minEdge, minWeight);
        }
        return newG;
    }

    private DefaultDirectedWeightedGraph<V, E> expand(DefaultDirectedWeightedGraph<V, E> g, List<V> cycle, Weighting weighting) {
        DirectedNeighborIndex ni = new DirectedNeighborIndex(g);
        double minWeightOutside = weighting == Weighting.MAX ? -1.7976931348623157E308 : Double.MAX_VALUE;
        double minWeightInside = weighting == Weighting.MAX ? -1.7976931348623157E308 : Double.MAX_VALUE;
        Object j = null;
        Object i = null;
        Object jInside = null;
        for (V j2 : cycle) {
            for (Object i2 : ni.predecessorsOf(j2)) {
                double w = g.getEdgeWeight(g.getEdge(i2, j2));
                if (!cycle.contains(i2)) {
                    if (!(weighting == Weighting.MIN ? minWeightOutside > w : minWeightOutside < w)) continue;
                    minWeightOutside = w;
                    i = i2;
                    j = j2;
                    continue;
                }
                if (!(weighting == Weighting.MIN ? minWeightInside > w : minWeightInside < w)) continue;
                minWeightInside = w;
                jInside = j2;
            }
        }
        if (i != null && j != null) {
            this.T.addVertex(i);
            this.T.addVertex(j);
            Object e = this.T.addEdge(i, j);
            this.T.setEdgeWeight(e, minWeightOutside);
        }
        Object prev = null;
        for (V v : cycle) {
            if (prev != null) {
                this.T.addVertex(prev);
                this.T.addVertex(v);
                Object ce = this.T.addEdge(prev, v);
                this.T.setEdgeWeight(ce, g.getEdgeWeight(g.getEdge(prev, v)));
            }
            prev = v;
        }
        if (j != null) {
            int idx = cycle.lastIndexOf(j);
            this.T.removeEdge(cycle.get(idx - 1), j);
        } else {
            int idx = cycle.lastIndexOf(jInside);
            this.T.removeEdge(cycle.get(idx - 1), jInside);
        }
        return g;
    }

    private List<V> getCycle(V v, DefaultDirectedWeightedGraph<V, E> g, Set<V> visited) {
        return this.getCycle(v, g, visited, new ArrayList());
    }

    private List<V> getCycle(V v, DefaultDirectedWeightedGraph<V, E> g, Set<V> visited, ArrayList<V> cycle) {
        cycle.add(v);
        log.debug((Object)("V=" + v + ",CYCLE=" + cycle + ",VISITED=" + visited));
        if (visited.contains(v)) {
            log.debug((Object)("VISITED contains " + v));
            int idx = cycle.indexOf(v);
            return idx != -1 && idx != cycle.size() - 1 ? cycle.subList(idx, cycle.size()) : null;
        }
        visited.add(v);
        DirectedNeighborIndex ni = new DirectedNeighborIndex(g);
        Set next = ni.successorsOf(v);
        if (next.isEmpty()) {
            return null;
        }
        for (Object v2 : next) {
            List cycleFound = this.getCycle(v2, g, visited, new ArrayList<V>(cycle));
            if (cycleFound == null) continue;
            return cycleFound;
        }
        return null;
    }

    public static void main(String[] args) {
        DefaultDirectedWeightedGraph g = new DefaultDirectedWeightedGraph(DefaultWeightedEdge.class);
        g.addVertex((Object)"a");
        g.addVertex((Object)"b");
        g.addVertex((Object)"c");
        g.addVertex((Object)"d");
        g.addVertex((Object)"e");
        g.addVertex((Object)"f");
        g.addVertex((Object)"g");
        g.addVertex((Object)"h");
        g.addVertex((Object)"i");
        g.addVertex((Object)"l");
        g.addVertex((Object)"m");
        g.addVertex((Object)"n");
        g.addVertex((Object)"x");
        g.addVertex((Object)"y");
        g.addVertex((Object)"z");
        g.addVertex((Object)"A");
        g.addVertex((Object)"B");
        g.addVertex((Object)"C");
        g.addVertex((Object)"D");
        g.addVertex((Object)"E");
        DefaultWeightedEdge e1 = (DefaultWeightedEdge)g.addEdge((Object)"a", (Object)"b");
        g.setEdgeWeight((Object)e1, 1.0);
        DefaultWeightedEdge e2 = (DefaultWeightedEdge)g.addEdge((Object)"b", (Object)"c");
        g.setEdgeWeight((Object)e2, 1.0);
        DefaultWeightedEdge e3 = (DefaultWeightedEdge)g.addEdge((Object)"c", (Object)"d");
        g.setEdgeWeight((Object)e3, 1.0);
        DefaultWeightedEdge e4 = (DefaultWeightedEdge)g.addEdge((Object)"d", (Object)"e");
        g.setEdgeWeight((Object)e4, 1.0);
        DefaultWeightedEdge e5 = (DefaultWeightedEdge)g.addEdge((Object)"c", (Object)"h");
        g.setEdgeWeight((Object)e5, 1.0);
        DefaultWeightedEdge e6 = (DefaultWeightedEdge)g.addEdge((Object)"d", (Object)"i");
        g.setEdgeWeight((Object)e6, 1.0);
        DefaultWeightedEdge e7 = (DefaultWeightedEdge)g.addEdge((Object)"e", (Object)"i");
        g.setEdgeWeight((Object)e7, 1.0);
        DefaultWeightedEdge e8 = (DefaultWeightedEdge)g.addEdge((Object)"d", (Object)"f");
        g.setEdgeWeight((Object)e8, 1.0);
        DefaultWeightedEdge e9 = (DefaultWeightedEdge)g.addEdge((Object)"e", (Object)"f");
        g.setEdgeWeight((Object)e9, 1.0);
        DefaultWeightedEdge e10 = (DefaultWeightedEdge)g.addEdge((Object)"d", (Object)"l");
        g.setEdgeWeight((Object)e10, 1.0);
        DefaultWeightedEdge e11 = (DefaultWeightedEdge)g.addEdge((Object)"f", (Object)"l");
        g.setEdgeWeight((Object)e11, 0.5);
        DefaultWeightedEdge e12 = (DefaultWeightedEdge)g.addEdge((Object)"i", (Object)"n");
        g.setEdgeWeight((Object)e12, 1.0);
        DefaultWeightedEdge e13 = (DefaultWeightedEdge)g.addEdge((Object)"l", (Object)"n");
        g.setEdgeWeight((Object)e13, 0.2);
        DefaultWeightedEdge e14 = (DefaultWeightedEdge)g.addEdge((Object)"a", (Object)"g");
        g.setEdgeWeight((Object)e14, 1.0);
        DefaultWeightedEdge e15 = (DefaultWeightedEdge)g.addEdge((Object)"g", (Object)"m");
        g.setEdgeWeight((Object)e15, 1.0);
        DefaultWeightedEdge e16 = (DefaultWeightedEdge)g.addEdge((Object)"n", (Object)"d");
        g.setEdgeWeight((Object)e16, 0.3);
        DefaultWeightedEdge e17 = (DefaultWeightedEdge)g.addEdge((Object)"n", (Object)"f");
        g.setEdgeWeight((Object)e17, 0.1);
        DefaultWeightedEdge e18 = (DefaultWeightedEdge)g.addEdge((Object)"i", (Object)"c");
        g.setEdgeWeight((Object)e18, 0.1);
        DefaultWeightedEdge e19 = (DefaultWeightedEdge)g.addEdge((Object)"m", (Object)"h");
        g.setEdgeWeight((Object)e19, 0.1);
        DefaultWeightedEdge e20 = (DefaultWeightedEdge)g.addEdge((Object)"h", (Object)"c");
        g.setEdgeWeight((Object)e20, 0.1);
        DefaultWeightedEdge e21 = (DefaultWeightedEdge)g.addEdge((Object)"x", (Object)"y");
        g.setEdgeWeight((Object)e21, 0.3);
        DefaultWeightedEdge e22 = (DefaultWeightedEdge)g.addEdge((Object)"y", (Object)"z");
        g.setEdgeWeight((Object)e22, 0.2);
        DefaultWeightedEdge e23 = (DefaultWeightedEdge)g.addEdge((Object)"z", (Object)"x");
        g.setEdgeWeight((Object)e23, 0.1);
        DefaultWeightedEdge e24 = (DefaultWeightedEdge)g.addEdge((Object)"A", (Object)"B");
        g.setEdgeWeight((Object)e24, 0.1);
        DefaultWeightedEdge e25 = (DefaultWeightedEdge)g.addEdge((Object)"B", (Object)"C");
        g.setEdgeWeight((Object)e25, 0.01);
        DefaultWeightedEdge e26 = (DefaultWeightedEdge)g.addEdge((Object)"C", (Object)"D");
        g.setEdgeWeight((Object)e26, 0.5);
        DefaultWeightedEdge e27 = (DefaultWeightedEdge)g.addEdge((Object)"D", (Object)"A");
        g.setEdgeWeight((Object)e27, 0.06);
        for (DefaultWeightedEdge e : g.edgeSet()) {
            g.setEdgeWeight((Object)e, 1.0 - g.getEdgeWeight((Object)e));
        }
        EdmondsAlgorithm a = new EdmondsAlgorithm();
        g = a.getOptimumBranching(g, Weighting.MAX);
        System.out.println("VERTICES = " + g.vertexSet());
        for (DefaultWeightedEdge e : g.edgeSet()) {
            log.info((Object)(e + ":" + g.getEdgeWeight((Object)e)));
        }
    }

    public static enum Weighting {
        MAX,
        MIN;

    }
}

