/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import it.uniroma1.lcl.jlt.jgrapht.SynsetWeightMap;
import it.uniroma1.lcl.jlt.jgrapht.WordNetGraph;
import it.uniroma1.lcl.jlt.util.Maps;
import it.uniroma1.lcl.jlt.wordnet.WordNet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public class DomainTreeExtractor {
    private static final Log log = LogFactory.getLog(DomainTreeExtractor.class);
    private WordNetGraph wordNetGraph;
    private SynsetWeightMap weights;
    private String domainName;
    private Set<ISynset> negativeSynsets = new HashSet<ISynset>();
    private Set<ISynset> positiveSynsets = new HashSet<ISynset>();
    public static final double threshold = 0.1;
    private Set<String> done = new HashSet<String>();

    public DomainTreeExtractor(String filename) {
        this.domainName = filename.substring(0, filename.indexOf("."));
        System.out.println(" == " + filename + " ==");
        log.info((Object)"Loading WordNet graph...");
        this.wordNetGraph = new WordNetGraph();
        System.out.println("SIZE = " + this.wordNetGraph.vertexSet().size());
        log.info((Object)"Loading weights...");
        this.weights = new SynsetWeightMap("TFIDF/" + filename);
        log.info((Object)"Calculating forces...");
    }

    public void run() {
        NumberFormat nf = DecimalFormat.getInstance(Locale.UK);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        WordNet wn = WordNet.getInstance();
        for (String lemma : this.weights.getSortedWords()) {
            if (this.weights.getWordWeight(lemma) < 0.1) break;
            System.out.println("ANALYZING " + lemma + " (weight = " + this.weights.getWordWeight(lemma) + ")");
            System.out.println("DONE = " + this.done.toString());
            if (this.done.contains(lemma)) {
                System.out.println("Already done: SKIPPING");
                System.out.println("-------------------------");
                continue;
            }
            double bestScore = 0.0;
            ISynset bestSynset = null;
            HashSet<ISynset> synsets = new HashSet<ISynset>();
            List<IWord> senses = wn.getSenses(lemma, POS.NOUN);
            for (IWord sense : senses) {
                ISynset synset = sense.getSynset();
                synsets.add(synset);
                if (!this.wordNetGraph.containsVertex(synset)) {
                    System.out.println("GRAPH DOES NOT CONTAIN " + wn.synsetToSenseString(lemma, synset));
                    continue;
                }
                double score = this.getScore(null, synset);
                System.out.println("  " + score + ":" + wn.synsetToSenseString(lemma, synset));
                if (!(bestScore < score)) continue;
                bestScore = score;
                bestSynset = synset;
            }
            if (bestScore > 0.1) {
                System.out.println("BEST = " + wn.synsetToSenseString(lemma, bestSynset));
                System.out.println("  SCORE = " + bestScore);
                synsets.remove(bestSynset);
                this.addPositiveSynset(bestSynset);
                for (ISynset negativeSynset : synsets) {
                    this.negativeSynsets.add(negativeSynset);
                    this.weights.setWeight(negativeSynset, -1.0);
                }
                for (ISynset n : Graphs.neighborListOf((Graph)this.wordNetGraph, bestSynset)) {
                    if (wn.isaDirect(bestSynset, n)) continue;
                    this.addPositiveSynset(n);
                    this.expand(bestSynset, n, 1);
                }
            }
            System.out.println("-------------------------");
        }
        for (ISynset positiveSynset : this.positiveSynsets) {
            System.out.println("POS = " + wn.synsetToSenseString(positiveSynset));
        }
        for (ISynset negativeSynset : this.negativeSynsets) {
            System.out.println("NEG = " + wn.synsetToSenseString(negativeSynset));
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".senses.txt"));
            BufferedWriter bw2 = new BufferedWriter(new FileWriter("TFIDF/" + this.domainName + ".trees.txt"));
            Map<ISynset, Double> treeScore = new HashMap();
            for (ISynset positiveSynset : this.positiveSynsets) {
                bw.write(String.valueOf(this.weights.getWeight(positiveSynset)) + "\t" + wn.synsetToSenseString(positiveSynset));
                bw.write("\n");
                double score = 0.0;
                for (ISynset d : wn.getDescendants(positiveSynset)) {
                    score += this.weights.getWeight(d);
                }
                treeScore.put(positiveSynset, score);
            }
            treeScore = Maps.sortByValue(treeScore, Maps.SortingOrder.DESCENDING);
            bw2.write("# number_of_descendants synset_TFIDF tree_TF_IDF_sum root_synset");
            for (ISynset s : treeScore.keySet()) {
                int size = wn.getDescendants(s).size();
                bw2.write(String.valueOf(size) + "\t" + this.weights.getWeight(s) + "\t" + treeScore.get(s) + "\t" + wn.synsetToSenseString(s));
                bw2.write("\n");
            }
            bw.close();
            bw2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\n\n");
    }

    private void addPositiveSynset(ISynset synset) {
        WordNet wn = WordNet.getInstance();
        this.positiveSynsets.add(synset);
        for (String lemma : wn.getLemmasFromSynset(synset)) {
            this.done.add(lemma.toLowerCase());
        }
    }

    private void expand(ISynset caller, ISynset s, int level) {
        System.out.println("EXPAND ON: " + WordNet.getInstance().synsetToSenseString(s));
        double score = this.getScore(caller, s);
        System.out.println("  SCORE = " + score);
        if (score > 0.1) {
            List neighbours = Graphs.neighborListOf((Graph)this.wordNetGraph, (Object)s);
            System.out.println("EXPANDING TO level " + level + ": " + neighbours);
            for (ISynset n : neighbours) {
                if (this.positiveSynsets.contains(s)) continue;
                this.expand(s, n, level + 1);
                this.addPositiveSynset(n);
            }
        }
    }

    public double getScore(ISynset caller, ISynset s) {
        if (caller != null) {
            System.out.println(" CALLER = " + WordNet.getInstance().synsetToSenseString(caller));
        }
        double score = 0.0;
        int zeros = 0;
        List neighbours = Graphs.neighborListOf((Graph)this.wordNetGraph, (Object)s);
        for (ISynset n : neighbours) {
            if (n.equals(caller)) continue;
            double w = this.weights.getWeight(n);
            System.out.println(" SUMMING: " + w + ":" + WordNet.getInstance().synsetToSenseString(n));
            score += w;
            if (w != 0.0) continue;
            ++zeros;
        }
        return score / (Math.log(zeros + 1) + 1.0);
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray = new File("TFIDF").list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.endsWith("csv")) {
                System.out.println(filename);
                new DomainTreeExtractor(filename).run();
            }
            ++n2;
        }
    }
}

