/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.jgrapht;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;

public class CentralityComputer<V, E> {
    private Graph<V, E> G;
    private HashMap<V, Integer> IndexMap;
    private Integer[][] DistanceMatrix;
    private Integer[][] AdjacencyMatrix;
    private List<List<Integer>> AdjacencyList;
    private int n;
    private Double[] Cb;

    public CentralityComputer(Graph<V, E> myGraph) {
        this.G = myGraph;
        this.n = this.G.vertexSet().size();
        this.IndexMap = new HashMap();
        int i = 0;
        int j = 0;
        for (Object vertex : this.G.vertexSet()) {
            this.IndexMap.put((Integer)vertex, i);
            ++i;
        }
        this.DistanceMatrix = new Integer[this.n][this.n];
        this.AdjacencyMatrix = new Integer[this.n][this.n];
        this.AdjacencyList = new ArrayList<List<Integer>>();
        i = 0;
        while (i < this.n) {
            j = 0;
            while (j < this.n) {
                this.DistanceMatrix[i][j] = 0;
                this.AdjacencyMatrix[i][j] = 0;
                ++j;
            }
            this.AdjacencyList.add(new ArrayList());
            ++i;
        }
        for (Object edge : this.G.edgeSet()) {
            i = this.IndexMap.get(this.G.getEdgeSource(edge));
            j = this.IndexMap.get(this.G.getEdgeTarget(edge));
            this.AdjacencyMatrix[i][j] = 1;
            this.AdjacencyMatrix[j][i] = 1;
            this.AdjacencyList.get(i).add(j);
            this.AdjacencyList.get(j).add(i);
        }
        this.Cb = new Double[this.n];
        Double[] sigma = new Double[this.n];
        Integer[] d = new Integer[this.n];
        Double[] delta = new Double[this.n];
        i = 0;
        while (i < this.n) {
            this.Cb[i] = 0.0;
            sigma[i] = 0.0;
            d[i] = 0;
            ++i;
        }
        ArrayList<Integer> S = new ArrayList<Integer>();
        LinkedList<Integer> Q = new LinkedList<Integer>();
        ArrayList P = new ArrayList();
        List tempVector = new ArrayList();
        List<Object> AdjVec = new ArrayList();
        Integer s = 0;
        while (s < this.n) {
            S.clear();
            P.clear();
            i = 0;
            while (i < this.n) {
                sigma[i] = 0.0;
                d[i] = -1;
                delta[i] = 0.0;
                P.add(new ArrayList());
                ++i;
            }
            sigma[s.intValue()] = 1.0;
            d[s.intValue()] = 0;
            Q.clear();
            Q.add(s);
            while (!Q.isEmpty()) {
                Integer v = (Integer)Q.remove();
                S.add(v);
                AdjVec = this.AdjacencyList.get(v);
                for (Integer n : AdjVec) {
                    if (d[n] < 0) {
                        d[n.intValue()] = d[v] + 1;
                        Q.add(n);
                    }
                    if (d[n] != d[v] + 1) continue;
                    sigma[n.intValue()] = sigma[n] + sigma[v];
                    ((List)P.get(n)).add(v);
                }
            }
            i = 0;
            while (i < this.n) {
                this.DistanceMatrix[s.intValue()][i] = d[i];
                this.DistanceMatrix[i][s.intValue()] = d[i];
                ++i;
            }
            while (!S.isEmpty()) {
                Integer n = (Integer)S.remove(S.size() - 1);
                tempVector = (List)P.get(n);
                for (Integer v : tempVector) {
                    delta[v.intValue()] = delta[v] + sigma[v] / sigma[n] * (1.0 + delta[n]);
                }
                if (n == s) continue;
                this.Cb[n.intValue()] = this.Cb[n] + delta[n];
            }
            s = s + 1;
        }
        if (this.n > 2) {
            i = 0;
            while (i < this.n) {
                this.Cb[i] = this.Cb[i] / (double)((this.n - 1) * (this.n - 2));
                ++i;
            }
        } else {
            i = 0;
            while (i < this.n) {
                this.Cb[i] = 1.0;
                ++i;
            }
        }
    }

    public Double findDegreeOf(V vertex) {
        Set EdgeSet = this.G.edgesOf(vertex);
        Integer D = EdgeSet.size();
        if (this.n > 1) {
            return D.doubleValue() / (double)(this.n - 1);
        }
        return 0.0;
    }

    public Double findClosenessOf(V vertex) {
        int m = this.IndexMap.get(vertex);
        Double sum = 0.0;
        int i = 0;
        while (i < m) {
            sum = sum + (double)this.DistanceMatrix[m][i].intValue();
            ++i;
        }
        i = m + 1;
        while (i < this.n) {
            sum = sum + (double)this.DistanceMatrix[m][i].intValue();
            ++i;
        }
        if (sum != 0.0 && this.n > 1) {
            return (double)(this.n - 1) / sum;
        }
        return 0.0;
    }

    public Double findBetweennessOf(V vertex) {
        return this.Cb[this.IndexMap.get(vertex)];
    }

    public Double findClusteringOf(V vertex) {
        Integer v = this.IndexMap.get(vertex);
        ArrayList<Integer> NeighborSet = new ArrayList<Integer>();
        NeighborSet.add(v);
        int i = 0;
        int j = 0;
        i = 0;
        while (i < this.n) {
            if (this.AdjacencyMatrix[v][i] == 1) {
                NeighborSet.add(i);
            }
            ++i;
        }
        if (NeighborSet.contains(v)) {
            NeighborSet.remove(v);
        }
        Integer Sum = 0;
        i = 0;
        while (i < NeighborSet.size()) {
            j = i + 1;
            while (j < NeighborSet.size()) {
                Integer ivertex = (Integer)NeighborSet.get(i);
                Integer jvertex = (Integer)NeighborSet.get(j);
                if (this.AdjacencyMatrix[ivertex][jvertex] == 1) {
                    Sum = Sum + 1;
                }
                ++j;
            }
            ++i;
        }
        Integer k = NeighborSet.size();
        if (k > 1) {
            Double D = 2.0 * Sum.doubleValue() / (k.doubleValue() * (k.doubleValue() - 1.0));
            return D;
        }
        return 0.0;
    }

    public Integer getDistance(V s, V t) {
        return this.DistanceMatrix[this.IndexMap.get(s)][this.IndexMap.get(t)];
    }
}

