/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.index.lucene;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.index.Index;
import it.uniroma1.lcl.jlt.index.Record;
import it.uniroma1.lcl.jlt.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;

public class LuceneIndex
extends Index {
    private final IndexSearcher is;

    public LuceneIndex(String id) throws IOException {
        super(id);
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(id));
        this.is = new IndexSearcher((Directory)dir, true);
    }

    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public List<Record> getRecords(String key, String[] values, String[] fields) throws IOException {
        Integer maxTopDocs = Configuration.getInstance().getMaxTopDocs();
        MultiPhraseQuery query = new MultiPhraseQuery();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            query.add(new Term(key, value));
            ++n2;
        }
        TopDocs top = this.is.search((Query)query, maxTopDocs.intValue());
        ArrayList<Record> docs = new ArrayList<Record>();
        ScoreDoc[] scoreDocArray = top.scoreDocs;
        int n3 = top.scoreDocs.length;
        int n4 = 0;
        while (n4 < n3) {
            ScoreDoc doc = scoreDocArray[n4];
            int docId = doc.doc;
            Document d = this.is.doc(docId);
            Record record = new Record();
            HashSet<String> fieldNames = new HashSet<String>();
            if (fields == null) {
                for (Object f : d.getFields()) {
                    Field field = (Field)f;
                    fieldNames.add(field.name());
                }
            } else {
                String[] stringArray2 = fields;
                int field = fields.length;
                int n5 = 0;
                while (n5 < field) {
                    Object f;
                    f = stringArray2[n5];
                    fieldNames.add((String)f);
                    ++n5;
                }
            }
            for (String field : fieldNames) {
                String[] recordValues = d.getValues(field.toString());
                record.add(field, recordValues);
            }
            docs.add(record);
            ++n4;
        }
        return docs;
    }

    @Override
    public List<Record> getRecords(List<Pair<String, String>> keyValues) throws IOException {
        Integer maxTopDocs = Configuration.getInstance().getMaxTopDocs();
        BooleanQuery query = new BooleanQuery();
        for (Pair<String, String> keyValue : keyValues) {
            query.add(new BooleanClause((Query)new TermQuery(new Term(keyValue.getFirst(), keyValue.getSecond())), BooleanClause.Occur.MUST));
        }
        TopDocs top = this.is.search((Query)query, maxTopDocs.intValue());
        ArrayList<Record> docs = new ArrayList<Record>();
        ScoreDoc[] scoreDocArray = top.scoreDocs;
        int n = top.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc doc = scoreDocArray[n2];
            int docId = doc.doc;
            Document d = this.is.doc(docId);
            Record record = new Record();
            for (Object f : d.getFields()) {
                Field field = (Field)f;
                String fieldName = field.name();
                String[] recordValues = d.getValues(fieldName);
                record.add(fieldName, recordValues);
            }
            docs.add(record);
            ++n2;
        }
        return docs;
    }

    public void removeRecords(String key, String value) throws IOException {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        pairs.add(new Pair<String, String>(key, value));
        this.removeRecords(pairs);
    }

    public void removeRecords(List<Pair<String, String>> keyValues) throws IOException {
        BooleanQuery query = new BooleanQuery();
        for (Pair<String, String> keyValue : keyValues) {
            query.add(new BooleanClause((Query)new TermQuery(new Term(keyValue.getFirst(), keyValue.getSecond())), BooleanClause.Occur.MUST));
        }
        IndexWriter writer = new IndexWriter(this.is.getIndexReader().directory(), (Analyzer)new StandardAnalyzer(Version.LUCENE_29), false, IndexWriter.MaxFieldLength.UNLIMITED);
        writer.deleteDocuments((Query)query);
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        LuceneIndex idx = new LuceneIndex("/home/roberto/workspace/Wiki2WN/resources/wiki_sentence_idx");
        for (Record r : idx.getRecords("title", "Revolution")) {
            System.out.println(r.get("sentence"));
        }
        idx.close();
    }
}

