/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.index.lucene;

import it.uniroma1.lcl.jlt.util.DoubleCounter;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;

public class DocumentFrequencyCounter {
    private final IndexReader reader;

    public DocumentFrequencyCounter(IndexReader reader) {
        this.reader = reader;
    }

    public DoubleCounter<String> getCounts() throws IOException {
        return this.getCounts("");
    }

    public DoubleCounter<String> getCounts(String field) throws IOException {
        return this.getCounts(field, 0);
    }

    public DoubleCounter<String> getCounts(String field, int threshold) throws IOException {
        return this.getCounts(field, threshold, false);
    }

    public DoubleCounter<String> getCounts(String field, int threshold, boolean inverse) throws IOException {
        int nDocs = this.reader.numDocs();
        TermEnum tEnum = this.reader.terms();
        DoubleCounter<String> counts = new DoubleCounter<String>();
        while (tEnum.next()) {
            String tField = tEnum.term().field();
            double docFreq = tEnum.docFreq();
            if (!field.isEmpty() && !tField.equals(field) || !(docFreq > (double)threshold)) continue;
            String text = tEnum.term().text();
            text = text.toLowerCase().replaceAll("\\s+", "_");
            counts.count(text, docFreq);
        }
        if (inverse) {
            DoubleCounter<String> inverseCounts = new DoubleCounter<String>();
            for (String text : counts.keySet()) {
                double docFreq = (Double)counts.get(text);
                double score = Math.log((double)nDocs / docFreq);
                inverseCounts.count(text, score);
            }
            return inverseCounts;
        }
        return counts;
    }
}

