/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.index;

import it.uniroma1.lcl.jlt.index.Record;
import it.uniroma1.lcl.jlt.index.lucene.LuceneIndex;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SentenceIndexExtractor {
    private String indexDir;

    public SentenceIndexExtractor(String indexDir) {
        this.indexDir = indexDir;
    }

    public List<String> extract(String term) throws IOException {
        return this.extract(new String[]{term});
    }

    public List<String> extract(String[] terms) throws IOException {
        LuceneIndex idx = new LuceneIndex(this.indexDir);
        ArrayList<String> sentences = new ArrayList<String>();
        List<Record> records = idx.getRecords("lemma", terms);
        for (Record record : records) {
            Collection<String> bow1 = record.getAll("lemma");
            Collection<String> bow2 = record.getAll("pos");
            ArrayList<String> lemmas = new ArrayList<String>();
            Iterator<String> i = bow2.iterator();
            for (String lemma : bow1) {
                String pos = i.next();
                switch (pos.charAt(0)) {
                    case 'J': 
                    case 'N': 
                    case 'V': {
                        lemmas.add(lemma);
                    }
                }
            }
            if (!lemmas.containsAll(Arrays.asList(terms))) continue;
            sentences.add(Strings.join(lemmas, "\t"));
        }
        idx.close();
        return sentences;
    }

    public List<Pair<String, Integer>> extractUnique(String term, Integer howMany, List<Integer> alreadyTakenIDs) throws IOException {
        LuceneIndex idx = new LuceneIndex(this.indexDir);
        ArrayList<Pair<String, Integer>> sentences = new ArrayList<Pair<String, Integer>>();
        List<Record> records = idx.getRecords("token", term);
        for (Record record : records) {
            if (sentences.size() > howMany && howMany != 0) {
                return sentences;
            }
            Collection<String> bow1 = record.getAll("token");
            Integer sID = Integer.parseInt(record.get("sID"));
            ArrayList<String> lemmas = new ArrayList<String>();
            for (String token : bow1) {
                lemmas.add(token);
            }
            if (alreadyTakenIDs.contains(sID)) continue;
            Pair<String, Integer> tempPair = new Pair<String, Integer>(Strings.join(lemmas, "\t"), sID);
            sentences.add(tempPair);
        }
        idx.close();
        return sentences;
    }
}

