/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.gigaword.iterator;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.minipar.MiniparSentence;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GigawordParsedDumpIterator
implements Iterator<MiniparSentence> {
    protected static final Log log = LogFactory.getLog(GigawordParsedDumpIterator.class);
    protected static final List<File> fileList = Files.listFiles(new File(Configuration.getInstance().getGigawordParsedDir()), ".*\\.gz");
    protected int files = 0;
    protected int sentences = 0;
    protected Iterator<File> iterator = fileList.iterator();
    protected File file;
    protected BufferedReader reader;
    protected int maxFiles;
    protected int maxSentences;

    public GigawordParsedDumpIterator() {
        this(Integer.MAX_VALUE);
    }

    public GigawordParsedDumpIterator(int maxFiles) {
        this(maxFiles, Integer.MAX_VALUE);
    }

    public GigawordParsedDumpIterator(int maxFiles, int maxSentences) {
        this.maxFiles = maxFiles;
        this.maxSentences = maxSentences;
        if (this.maxFiles == Integer.MAX_VALUE) {
            this.maxFiles = fileList.size();
        }
        log.info((Object)("|Gigaword| = " + fileList.size() + " files to be scanned. [Read " + (this.maxFiles == Integer.MAX_VALUE ? "ALL" : Integer.valueOf(this.maxFiles)) + " files] [Read " + (this.maxSentences == Integer.MAX_VALUE ? "ALL" : Integer.valueOf(this.maxSentences)) + " sentences]"));
    }

    public void skipFiles(int n) {
        int i = 0;
        while (i < n && this.iterator.hasNext()) {
            log.info((Object)("Skipping " + this.iterator.next().getName()));
            ++i;
            ++this.files;
        }
    }

    public void skipSentences(int n) {
        int i = 0;
        while (i < n && this.hasNext()) {
            this.next();
            ++i;
            ++this.sentences;
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.makeSureOpenFile()) {
            return false;
        }
        if (this.sentences > this.maxSentences - 1) {
            return false;
        }
        return this.files <= this.maxFiles;
    }

    protected boolean makeSureOpenFile() {
        block6: {
            block5: {
                if (this.reader != null) {
                    return true;
                }
                if (this.iterator.hasNext()) break block5;
                return false;
            }
            if (this.files < this.maxFiles) break block6;
            return false;
        }
        try {
            this.file = this.iterator.next();
            ++this.files;
            GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(this.file));
            this.reader = new BufferedReader(new InputStreamReader(gzip));
            log.info((Object)(String.valueOf(this.files) + ") Opening file " + this.file.getAbsolutePath() + " [Total sentences number: " + this.getCurrentSentenceNumber() + "]"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected MiniparSentence loadNext() {
        MiniparSentence next = null;
        try {
            String sentence = "";
            String line = null;
            while ((line = this.reader.readLine()) != null && !line.startsWith(")")) {
                sentence = line.startsWith("(") ? String.valueOf(line) + "\n" : String.valueOf(sentence) + line + "\n";
            }
            if (line == null) {
                this.reader.close();
                this.reader = null;
            }
            sentence = String.valueOf(sentence) + line + "\n";
            next = new MiniparSentence(sentence);
            ++this.sentences;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return next;
    }

    public String getCurrentFile() {
        return this.file.getName();
    }

    public int getCurrentFileNumber() {
        return this.files;
    }

    public int getTotalFileNumber() {
        return this.maxFiles;
    }

    public int getCurrentSentenceNumber() {
        return this.sentences;
    }

    @Override
    public MiniparSentence next() {
        return this.loadNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static void main(String[] args) {
        GigawordParsedDumpIterator gigaparsed = new GigawordParsedDumpIterator(2, 10);
        while (gigaparsed.hasNext()) {
            MiniparSentence sentence = gigaparsed.next();
            log.info((Object)(String.valueOf(gigaparsed.getCurrentSentenceNumber()) + ") " + sentence.getContentWords()));
        }
        log.info((Object)("Sentences read: " + gigaparsed.getCurrentSentenceNumber()));
    }
}

