/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.gigaword.iterator;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.gigaword.iterator.GigawordParseTree;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Strings;
import it.uniroma1.lcl.jlt.util.Triple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GigawordParseTreeDumpIterator
implements Iterator<GigawordParseTree>,
FilenameFilter {
    private static final Log log = LogFactory.getLog(GigawordParseTreeDumpIterator.class);
    private BufferedReader buffered_stream;
    private Iterator<File> dumpFileIterator;
    private GigawordParseTree nextParseTree;

    public GigawordParseTreeDumpIterator() {
        File dir = new File(Configuration.getInstance().getGigawordParsedDir());
        List<File> dumpFiles = Files.listFiles(dir, this, false);
        this.dumpFileIterator = dumpFiles.iterator();
        this.nextParseTree = null;
    }

    @Override
    public boolean accept(File dir, String filename) {
        return filename.endsWith(".gz");
    }

    public void open() throws IOException {
        this.openNextFile();
    }

    protected boolean openNextFile() throws FileNotFoundException, IOException {
        if (this.buffered_stream != null) {
            this.close();
        }
        if (!this.dumpFileIterator.hasNext()) {
            return false;
        }
        File nextDumpFile = this.dumpFileIterator.next();
        GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(nextDumpFile));
        this.buffered_stream = new BufferedReader(new InputStreamReader(gzis));
        return true;
    }

    public void close() throws IOException {
        this.buffered_stream.close();
    }

    @Override
    public boolean hasNext() {
        if (this.nextParseTree == null) {
            this.nextParseTree = this.next();
        }
        return this.nextParseTree != null;
    }

    @Override
    public GigawordParseTree next() {
        if (this.nextParseTree != null) {
            GigawordParseTree next = this.nextParseTree;
            this.nextParseTree = null;
            return next;
        }
        GigawordParseTree text = null;
        try {
            while ((text = this.readNextSentence()) == null && !this.openNextFile()) {
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    protected GigawordParseTree readNextSentence() throws IOException {
        GigawordParseTree tree = new GigawordParseTree();
        String ID = "\\w+";
        String WORD = "[^\\t]+";
        String LEMMA = "[^\\t]+";
        String POS2 = "\\w+";
        String ROLE = "[^\\t]+";
        String NUM_FATHER = "\\w+";
        String FATHER = "[^)]+";
        String LEFT_P = "\\(";
        String RIGHT_P = "\\)";
        String REGEX = "(" + ID + ")\\t" + LEFT_P + "(" + WORD + ")\\t(" + LEMMA + ") (" + POS2 + ")\\t(" + NUM_FATHER + ")\\t(" + ROLE + ")\\t" + LEFT_P + "gov (" + FATHER + ")" + RIGHT_P + RIGHT_P;
        Pattern p = Pattern.compile(REGEX);
        HashMap idWords = null;
        boolean sentstart = false;
        String line = null;
        while ((line = this.buffered_stream.readLine()) != null) {
            if (line.startsWith("(")) {
                sentstart = true;
                idWords = new HashMap();
                continue;
            }
            if (line.startsWith(")")) {
                sentstart = false;
                for (String key : idWords.keySet()) {
                    HashMap items = (HashMap)idWords.get(key);
                    String employee = (String)items.get("LEMMA");
                    String employee_pos = (String)items.get("POS");
                    String employee_pos_tag = String.valueOf(employee_pos.charAt(0));
                    String employee_role = (String)items.get("ROLE");
                    String employer_id = (String)items.get("FATHER_ID");
                    String employer = (String)items.get("FATHER");
                    if (!idWords.containsKey(employer_id)) {
                        log.debug((Object)(String.valueOf(employee) + " has no father (?)"));
                        continue;
                    }
                    String employer_pos = (String)((HashMap)idWords.get(employer_id)).get("POS");
                    String employer_pos_tag = String.valueOf(((String)((HashMap)idWords.get(employer_id)).get("POS")).charAt(0));
                    String relation = null;
                    if (employer_pos.startsWith("prep")) {
                        HashMap verb_map;
                        HashMap prep_map = (HashMap)idWords.get(employer_id);
                        if (!((String)prep_map.get("ROLE")).equals("mod") || (verb_map = (HashMap)idWords.get(prep_map.get("FATHER_ID"))) == null || !((String)verb_map.get("POS")).startsWith("v")) continue;
                        String super_employer = (String)verb_map.get("LEMMA");
                        String super_employer_pos = (String)verb_map.get("POS");
                        String super_employer_pos_tag = String.valueOf(super_employer_pos.charAt(0));
                        if (employee_pos.startsWith("n") && employee_role.equals("pcomp-n")) {
                            employer = String.valueOf(super_employer) + "_" + (String)prep_map.get("LEMMA");
                            employer_pos = super_employer_pos;
                            employer_pos_tag = super_employer_pos_tag;
                            relation = "v-prep-n";
                        }
                    } else if (employee_role.equals("s") && employer_pos.startsWith("v")) {
                        relation = "subj-v";
                    } else if (employee_role.equals("obj") && employer_pos.startsWith("v")) {
                        relation = "v-obj";
                    } else if (employee_pos.startsWith("a") && employee_role.equals("mod") && employer_pos.startsWith("n")) {
                        relation = "a-mod-n";
                        String aux = employer;
                        employer = employee;
                        employee = aux;
                        aux = employer_pos;
                        employer_pos = employee_pos;
                        employee_pos = aux;
                        aux = employer_pos_tag;
                        employer_pos_tag = employee_pos_tag;
                        employee_pos_tag = aux;
                    }
                    if (relation == null) {
                        log.debug((Object)("No relation found for this word " + employee));
                        continue;
                    }
                    employer = String.valueOf(employer) + "#" + employer_pos_tag;
                    employee = String.valueOf(employee) + "#" + employee_pos_tag;
                    tree.addRelation(new Triple<String, String, String>(employee, relation, employer));
                }
                continue;
            }
            if (!sentstart) continue;
            log.debug((Object)line);
            Matcher m = p.matcher(line);
            if (!m.find()) {
                log.debug((Object)("Skipping '" + line + "' because it did not match"));
                continue;
            }
            String id = m.group(1).toLowerCase();
            String word = m.group(2).toLowerCase();
            if (word.equals("()")) continue;
            String lemma = m.group(3).toLowerCase();
            String pos = m.group(4).toLowerCase();
            String num_father = m.group(5);
            String role = m.group(6).toLowerCase();
            String father = m.group(7).toLowerCase();
            String base_word = lemma.equals("~") ? word : lemma;
            base_word = base_word.replaceAll("\"", "").replaceAll(" ", "_");
            father = father.replaceAll("\"", "").replaceAll(" ", "_");
            log.debug((Object)("ID=" + id + "\t" + Strings.rightFillWith(String.valueOf(base_word) + "#" + pos, ' ', 30) + "\tNUM_FATHER=" + Strings.rightFillWith(num_father, ' ', 20) + "\tROLE=" + Strings.rightFillWith(role, ' ', 20) + "\tFATHER=" + Strings.rightFillWith(father, ' ', 20)));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("LEMMA", base_word);
            properties.put("POS", pos);
            properties.put("ROLE", role);
            properties.put("FATHER_ID", num_father);
            properties.put("FATHER", father);
            idWords.put(id, properties);
        }
        return tree;
    }

    @Override
    public void remove() {
        this.dumpFileIterator.remove();
    }

    public static void main(String[] args) throws IOException {
        GigawordParseTreeDumpIterator giga_ti = new GigawordParseTreeDumpIterator();
        giga_ti.open();
        while (giga_ti.hasNext()) {
            System.out.println(giga_ti.next());
        }
        giga_ti.close();
    }
}

