/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.europarl;

import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.Constants;
import it.uniroma1.lcl.jlt.europarl.EuroparlLangPairs;
import it.uniroma1.lcl.jlt.europarl.SentencePair;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import it.uniroma1.lcl.jlt.util.Pair;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class EuroparlIterator
implements Iterator<SentencePair> {
    private InputStreamReader xover;
    private BufferedReader sourceSent;
    private BufferedReader targetSent;
    private Pair<String, String> parallelFiles;
    private String europarlDir;
    SentencePair nextPair = null;

    public EuroparlIterator(EuroparlLangPairs lpair) {
        String prefix = "europarl-v7.";
        this.europarlDir = "/home/pilehvar/Europarl/it-en/";
        String corpusName = lpair.toString();
        this.parallelFiles = new Pair<String, String>(String.valueOf(this.europarlDir) + prefix + corpusName + "." + lpair.getSource(lpair) + ".tok", String.valueOf(this.europarlDir) + prefix + corpusName + "." + lpair.getTarget(lpair) + ".tok");
    }

    public void open() {
        try {
            if (this.sourceSent != null && this.targetSent != null) {
                this.close();
            }
            FileInputStream fin = new FileInputStream(this.parallelFiles.getFirst());
            this.xover = new InputStreamReader((InputStream)fin, "UTF-8");
            this.sourceSent = new BufferedReader(this.xover, Configuration.getInstance().getBufferSizeReader() * Constants.KBYTE);
            fin = new FileInputStream(this.parallelFiles.getSecond());
            this.xover = new InputStreamReader((InputStream)fin, "UTF-8");
            this.targetSent = new BufferedReader(this.xover, Configuration.getInstance().getBufferSizeReader() * Constants.KBYTE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.sourceSent.close();
            this.targetSent.close();
            this.xover.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextPair == null) {
            this.nextPair = this.next();
        }
        return this.nextPair != null;
    }

    @Override
    public SentencePair next() {
        SentencePair pair;
        block7: {
            block6: {
                pair = new SentencePair();
                if (this.sourceSent.ready() && this.targetSent.ready()) break block6;
                this.nextPair = null;
                return null;
            }
            if (this.sourceSent != null && this.targetSent != null) break block7;
            return null;
        }
        try {
            String sourceTextLine = this.sourceSent.readLine();
            String targetTextLine = this.targetSent.readLine();
            StanfordSentence srcSentence = new StanfordSentence();
            String[] stringArray = sourceTextLine.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token;
                String word = token = stringArray[n2];
                String tag = null;
                String lemma = token;
                srcSentence.addWord(new WordLemmaTag(word, lemma, tag));
                ++n2;
            }
            StanfordSentence trgSentence = new StanfordSentence();
            String[] stringArray2 = targetTextLine.split(" ");
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String token;
                String word = token = stringArray2[n];
                String tag = null;
                String lemma = token;
                trgSentence.addWord(new WordLemmaTag(word, lemma, tag));
                ++n;
            }
            pair.SetSourceSentence(srcSentence);
            pair.SetTargetSentence(trgSentence);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pair;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported operation 'remove'");
    }

    public static void main(String[] args) throws IOException {
        int counter = 0;
        EuroparlIterator euIterator = new EuroparlIterator(EuroparlLangPairs.ItalianEnglish);
        euIterator.open();
        while (euIterator.hasNext()) {
            SentencePair eu = euIterator.next();
            if (++counter % 100000 != 0) continue;
            System.out.print(String.valueOf(counter) + "\t");
            System.out.println(eu.getPair());
        }
        System.out.print("Total Sentence Pairs: " + counter);
        euIterator.close();
    }
}

