/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.util.condition;

import it.uniroma1.lcl.jlt.dev.util.condition.Condition;
import it.uniroma1.lcl.jlt.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class TimeStepCondition
extends Condition {
    private static final Log log = LogFactory.getLog(TimeStepCondition.class);
    private static long DEFAULT_MS_STEP = 5000L;
    private final Timer timer = new Timer();
    private final long step;
    private final long start;
    private long lastTime;

    public TimeStepCondition() {
        this(DEFAULT_MS_STEP);
    }

    public TimeStepCondition(long step) {
        this.step = step;
        this.lastTime = this.start = this.timer.getTime();
    }

    @Override
    public boolean verifies() {
        long now = this.timer.getTime();
        return now - this.lastTime > this.step;
    }

    @Override
    public void takeEffect() {
        long now = this.timer.getTime();
        long periodToConsider = now - this.lastTime;
        while (periodToConsider > this.step) {
            log.info((Object)(this.getId() + ": " + "Time: " + Timer.getTimeFromMilliseconds(this.lastTime) + " [" + (now - this.start) + " ms from the start]"));
            this.lastTime = this.timer.getTime();
            periodToConsider -= this.step;
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"config/log4j.properties");
        TimeStepCondition timeCondition = new TimeStepCondition(1000L);
        while (true) {
            if (!timeCondition.verifies()) {
                continue;
            }
            timeCondition.takeEffect();
        }
    }
}

