/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.util.condition;

import com.google.common.collect.Lists;
import it.uniroma1.lcl.jlt.dev.util.condition.ComplexCondition;
import it.uniroma1.lcl.jlt.dev.util.condition.Condition;
import it.uniroma1.lcl.jlt.dev.util.condition.IntegerCondition;
import it.uniroma1.lcl.jlt.dev.util.condition.PercentageCondition;
import it.uniroma1.lcl.jlt.dev.util.condition.TimeCondition;
import org.apache.log4j.PropertyConfigurator;

public class StandardComplexCondition
extends ComplexCondition {
    public StandardComplexCondition(long ms, int step) {
        super(Lists.newArrayList((Object[])new Condition[]{new TimeCondition(ms), new IntegerCondition(step)}));
    }

    public StandardComplexCondition(long ms, double percentage, int total) {
        super(Lists.newArrayList((Object[])new Condition[]{new TimeCondition(ms), new PercentageCondition(percentage, total)}));
    }

    public StandardComplexCondition(long ms, int step, int total) {
        super(Lists.newArrayList((Object[])new Condition[]{new TimeCondition(ms), new IntegerCondition(step, total)}));
    }

    public StandardComplexCondition(long ms, int step, double percentage, int total) {
        super(Lists.newArrayList((Object[])new Condition[]{new TimeCondition(ms), new IntegerCondition(step), new PercentageCondition(percentage, total)}));
    }

    public void update(int current) {
        for (Condition c : this.conditions) {
            if (!(c instanceof IntegerCondition)) continue;
            ((IntegerCondition)c).update(current);
        }
    }

    public void triggerAndIncrement() {
        for (Condition c : this.conditions) {
            if (c instanceof IntegerCondition) {
                ((IntegerCondition)c).triggerAndIncrement();
                continue;
            }
            c.trigger();
        }
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int i) {
        for (Condition c : this.conditions) {
            if (!(c instanceof IntegerCondition)) continue;
            ((IntegerCondition)c).increment(i);
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"config/log4j.properties");
        StandardComplexCondition condition = new StandardComplexCondition(5000L, 10000, 1.0E-4, 1000000000);
        int i = 0;
        while (i < 1000000000) {
            condition.update(i);
            if (condition.verifies()) {
                condition.takeEffect();
            }
            ++i;
        }
    }
}

