/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.util.condition;

import it.uniroma1.lcl.jlt.dev.util.condition.IntegerCondition;
import it.uniroma1.lcl.jlt.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class PercentageCondition
extends IntegerCondition {
    private static final Log log = LogFactory.getLog(PercentageCondition.class);

    public PercentageCondition(double percentage, int total) {
        this(Math.max((int)((double)total * percentage), 1), total);
    }

    public PercentageCondition(int step, int total) {
        super(step, total);
    }

    @Override
    public void takeEffect() {
        log.info((Object)(this.getId() + ": " + this.current + (this.total != Integer.MAX_VALUE ? "/" + this.total : "") + " steps done" + (this.total != Integer.MAX_VALUE ? " [" + Strings.getPercentage(this.current, this.total) + "]" : "")));
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"config/log4j.properties");
        PercentageCondition timeCondition = new PercentageCondition(0.05, 1000);
        int i = 0;
        while (i < 1000) {
            timeCondition.update(i);
            if (timeCondition.verifies()) {
                timeCondition.takeEffect();
            }
            ++i;
        }
    }
}

