/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.util.condition;

import it.uniroma1.lcl.jlt.dev.util.condition.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class IntegerCondition
extends Condition {
    private static final Log log = LogFactory.getLog(IntegerCondition.class);
    protected int current;
    protected int step;
    protected int total;
    private int lastCheck;

    public IntegerCondition(int step) {
        this(step, Integer.MAX_VALUE);
    }

    public IntegerCondition(int step, int total) {
        this.step = step;
        this.total = total;
    }

    @Override
    public boolean verifies() {
        if (this.current == this.lastCheck) {
            return false;
        }
        this.lastCheck = this.current;
        return this.lastCheck % this.step == 0;
    }

    @Override
    public void takeEffect() {
        log.info((Object)(this.getId() + ": " + this.current + (this.total != Integer.MAX_VALUE ? "/" + this.total : "") + " steps done"));
    }

    public void update(int newCurrent) {
        this.current = newCurrent;
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int i) {
        this.update(this.current + i);
    }

    public void triggerAndIncrement() {
        this.increment();
        this.trigger();
    }

    public int getCurrent() {
        return this.current;
    }

    public int getTotal() {
        return this.total;
    }

    public int getStep() {
        return this.step;
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"config/log4j.properties");
        IntegerCondition timeCondition = new IntegerCondition(10, 1000);
        int i = 0;
        while (i < 1000) {
            timeCondition.triggerAndIncrement();
            ++i;
        }
    }
}

