/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.sentence;

import it.uniroma1.lcl.jlt.dev.words.Word;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordTokenizer;
import it.uniroma1.lcl.jlt.util.Language;
import it.uniroma1.lcl.jlt.util.Strings;
import java.util.ArrayList;
import java.util.List;

public class Sentence
extends ArrayList<Word> {
    private static final long serialVersionUID = 8674192433362866250L;
    private String original;
    public static final StanfordTokenizer tokenizer = StanfordTokenizer.getInstance();

    public Sentence(String original) {
        this.original = original;
    }

    public static Sentence createSentence(String sentenceString) {
        return Sentence.createSentence(sentenceString, Language.EN);
    }

    public static Sentence createSentence(String sentenceString, Language language) {
        List<edu.stanford.nlp.ling.Word> tokenize = tokenizer.tokenize(sentenceString);
        Sentence sentence = new Sentence(sentenceString);
        for (edu.stanford.nlp.ling.Word word : tokenize) {
            sentence.add(new Word(word.word(), language));
        }
        return sentence;
    }

    public String getOriginalString() {
        return this.original;
    }

    @Override
    public String toString() {
        return Strings.join(this, " ");
    }
}

