/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.pipelines;

import edu.mit.jwi.item.POS;
import edu.stanford.nlp.ling.TaggedWord;
import it.uniroma1.lcl.jlt.dev.pipelines.Filter;
import it.uniroma1.lcl.jlt.dev.sentence.Sentence;
import it.uniroma1.lcl.jlt.dev.words.WordLemmaPos;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordPOSTagger;

public class PosTagger
extends Filter {
    public static final StanfordPOSTagger tagger = StanfordPOSTagger.getInstance();

    @Override
    public Sentence filter(Sentence sentence) {
        Sentence filtered = new Sentence(sentence.getOriginalString());
        for (TaggedWord word : tagger.tag(sentence.getOriginalString())) {
            POS pos = StanfordPOSTagger.getPOSFromTag(word.tag());
            if (pos == null) continue;
            filtered.add(new WordLemmaPos(word.value(), word.value(), pos));
        }
        return filtered;
    }
}

