/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.pipelines;

import it.uniroma1.lcl.jlt.dev.lexicon.WordNetLexicon;
import it.uniroma1.lcl.jlt.dev.pipelines.CompoundMerger;
import it.uniroma1.lcl.jlt.dev.pipelines.Filter;
import it.uniroma1.lcl.jlt.dev.pipelines.Lemmatizer;
import it.uniroma1.lcl.jlt.dev.pipelines.PosTagger;
import it.uniroma1.lcl.jlt.dev.pipelines.StopwordsRemover;
import it.uniroma1.lcl.jlt.dev.sentence.Sentence;
import java.util.ArrayList;

public class PipelineProcessor
extends ArrayList<Filter> {
    private static final long serialVersionUID = -3821486270868088426L;

    public Sentence applyTo(Sentence sentence) {
        for (Filter filter : this) {
            sentence = filter.filter(sentence);
        }
        return sentence;
    }

    public static void main(String[] args) {
        Sentence sentence = Sentence.createSentence("united nations The computer giant has agreed to invest in the digital-book business in a deal that gives the company a new foothold in the market");
        PipelineProcessor pipeline = new PipelineProcessor();
        pipeline.add(new Lemmatizer());
        pipeline.add(new PosTagger());
        pipeline.add(new StopwordsRemover());
        pipeline.add(new CompoundMerger(WordNetLexicon.getInstance()));
        sentence = pipeline.applyTo(sentence);
        System.out.println(sentence);
    }
}

