/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.pipelines;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.dev.pipelines.Filter;
import it.uniroma1.lcl.jlt.dev.sentence.Sentence;
import it.uniroma1.lcl.jlt.dev.words.WordLemma;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordLemmatizer;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordPOSTagger;

public class Lemmatizer
extends Filter {
    public static final StanfordPOSTagger tagger = StanfordPOSTagger.getInstance();
    public static final StanfordLemmatizer lemmatizer = StanfordLemmatizer.getInstance();

    @Override
    public Sentence filter(Sentence sentence) {
        Sentence filtered = new Sentence(sentence.getOriginalString());
        for (TaggedWord word : tagger.tag(sentence.toString())) {
            WordLemmaTag tagged = lemmatizer.lemmatize(word);
            filtered.add(new WordLemma(tagged.word(), tagged.lemma()));
        }
        return filtered;
    }
}

