/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.gigaword;

import it.uniroma1.lcl.jlt.bnc.CorpusIterator;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnimplementedMethodException;
import it.uniroma1.lcl.jlt.dev.gigaword.GigawordIterator;
import it.uniroma1.lcl.jlt.dev.gigaword.GigawordSentence;
import it.uniroma1.lcl.jlt.dev.util.condition.IntegerCondition;
import it.uniroma1.lcl.jlt.pipeline.stanford.DataProcessor;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GigawordSentenceIterator
extends CorpusIterator {
    private static final Log log = LogFactory.getLog(GigawordSentenceIterator.class);
    private GigawordIterator textIterator;
    private Iterator<GigawordSentence> sentenceIterator;
    private StanfordSentence next;
    protected static final DataProcessor processor = DataProcessor.getInstance();

    public GigawordSentenceIterator() {
        this(GigawordIterator.GigaVersion.VERSION_5);
    }

    public GigawordSentenceIterator(GigawordIterator.GigaVersion version) {
        this.textIterator = new GigawordIterator(version);
        this.sentenceIterator = this.textIterator.next().iterator();
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public StanfordSentence next() {
        StanfordSentence toReturn = this.next;
        this.getNext();
        return toReturn;
    }

    private void getNext() {
        if (!this.sentenceIterator.hasNext() && !this.textIterator.hasNext()) {
            this.next = null;
            return;
        }
        if (!this.sentenceIterator.hasNext()) {
            this.sentenceIterator = this.textIterator.next().iterator();
            this.getNext();
            return;
        }
        this.next = new StanfordSentence(processor.processSentence(this.sentenceIterator.next().getSentence()));
    }

    @Override
    public void remove() {
        throw new UnimplementedMethodException();
    }

    public static void main(String[] args) {
        GigawordSentenceIterator iterator = new GigawordSentenceIterator();
        IntegerCondition condition = new IntegerCondition(1000);
        condition.setId("SENTENCES READ");
        int sentence = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++sentence;
            condition.triggerAndIncrement();
        }
        condition.takeEffect();
        log.info((Object)("TOTAL SENTENCES: " + sentence));
    }
}

