/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.dev.gigaword;

import it.uniroma1.lcl.jlt.dev.gigaword.GigawordDocument;
import it.uniroma1.lcl.jlt.dev.gigaword.GigawordIterator;
import it.uniroma1.lcl.jlt.dev.gigaword.GigawordSentence;
import it.uniroma1.lcl.jlt.dev.util.condition.IntegerCondition;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Gigaword2Txt {
    private static Log log = LogFactory.getLog(Gigaword2Txt.class);

    public static void main(String[] args) throws IOException {
        GigawordIterator.GigaVersion version = GigawordIterator.GigaVersion.valueOf(args[0]);
        String outputFile = args[1];
        log.info((Object)("Exporting gigaword version=" + (Object)((Object)version) + " out to file=" + outputFile));
        IntegerCondition condition = new IntegerCondition(1000);
        condition.setId("Sentences written");
        BufferedWriter writer = Files.getBufferedWriter(outputFile);
        GigawordIterator giga = new GigawordIterator(version);
        while (giga.hasNext()) {
            GigawordDocument gigatext = giga.next();
            for (GigawordSentence sentence : gigatext) {
                writer.write(String.valueOf(sentence.getID()) + "\t" + sentence.getSentence() + "\n");
                condition.triggerAndIncrement();
            }
            writer.flush();
        }
        writer.close();
    }
}

