/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.Lexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.util.ObjectManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MySQLLexicon
extends Lexicon {
    private final Connection conn;
    private final Map<String, Integer> word2id = new HashMap<String, Integer>();
    private final Map<Integer, String> id2word = new HashMap<Integer, String>();
    private final Map<Integer, Long> id2count = new HashMap<Integer, Long>();

    protected static MySQLLexicon getMySQLLexiconInstance(CollocsDB collocsDB) {
        ObjectManager manager = ObjectManager.getInstance();
        if (!manager.contains(MySQLLexicon.class, (Object)collocsDB)) {
            manager.put(MySQLLexicon.class, (Object)collocsDB, new MySQLLexicon(collocsDB));
        }
        return manager.get(MySQLLexicon.class, (Object)collocsDB);
    }

    private MySQLLexicon(CollocsDB collocsDB) {
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
            Configuration config = Configuration.getInstance();
            this.conn = DriverManager.getConnection(config.getCollocsLocation(collocsDB), config.getCollocsUser(collocsDB), config.getCollocsPassword(collocsDB));
            this.load();
            this.conn.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot init: " + e + ". Check the jlt.properties file.");
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void load() throws SQLException {
        Statement stmt = this.conn.createStatement();
        StringBuffer sb = new StringBuffer();
        sb.append("select * from lexicon");
        ResultSet rs = stmt.executeQuery(sb.toString());
        while (rs.next()) {
            Integer id = rs.getInt("id");
            String word = rs.getString("word");
            Long count = rs.getLong("count");
            this.word2id.put(word, id);
            this.id2word.put(id, word);
            this.id2count.put(id, count);
        }
        rs.close();
        stmt.close();
    }

    @Override
    public Integer getInteger(String word) {
        return this.word2id.get(word);
    }

    @Override
    public String getWord(int k) {
        return this.id2word.get(k);
    }

    @Override
    public Set<Integer> getIds() {
        return this.id2word.keySet();
    }

    @Override
    public long getCount(String word) {
        Integer id = this.word2id.get(word);
        if (id == null) {
            return 0L;
        }
        return this.id2count.get(id);
    }

    @Override
    public long getCount(Integer id) {
        if (id == null) {
            return 0L;
        }
        return this.id2count.get(id);
    }

    @Override
    public int getId(String word) {
        Integer id = this.word2id.get(word);
        if (id == null) {
            throw new RuntimeException(String.valueOf(word) + " is not contained in lexicon");
        }
        return id;
    }

    @Override
    public long size() {
        return this.id2count.size();
    }

    @Override
    public boolean contains(String word) {
        return this.word2id.containsKey(word);
    }

    @Override
    public Set<String> getLexiconWords() {
        return this.word2id.keySet();
    }

    public static void main(String[] args) {
        Lexicon lexicon = MySQLLexicon.getInstance();
        System.out.println(lexicon.getInteger("apple"));
        System.out.println("count(apple)=" + lexicon.getCount("apple"));
        System.out.println("count(pizza)=" + lexicon.getCount("pizza"));
        lexicon.close();
    }

    @Override
    public long getTotalCount() {
        long result = 0L;
        for (long value : this.id2count.values()) {
            result += value;
        }
        return result;
    }
}

