/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.Collocs;
import it.uniroma1.lcl.jlt.collocs.Lexicon;
import it.uniroma1.lcl.jlt.collocs.MySQLLexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.util.Cooccurrence;
import it.uniroma1.lcl.jlt.util.ObjectManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MySQLCollocs
extends Collocs {
    private final Connection conn;
    private final Lexicon lexicon;

    private MySQLCollocs(CollocsDB collocsDB) {
        try {
            Configuration config = Configuration.getInstance();
            Class.forName("org.gjt.mm.mysql.Driver");
            this.conn = DriverManager.getConnection(config.getCollocsLocation(collocsDB), config.getCollocsUser(collocsDB), config.getCollocsPassword(collocsDB));
            this.collocsDB = collocsDB;
            this.lexicon = MySQLLexicon.getInstance(collocsDB);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot init: " + e);
        }
    }

    protected static synchronized MySQLCollocs getMySQLCollocsInstance(CollocsDB collocsDB) {
        ObjectManager manager = ObjectManager.getInstance();
        if (!manager.contains(MySQLCollocs.class, (Object)collocsDB)) {
            manager.put(MySQLCollocs.class, (Object)collocsDB, new MySQLCollocs(collocsDB));
        }
        return manager.get(MySQLCollocs.class, (Object)collocsDB);
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CollocsDB getCollocsDB() {
        return this.collocsDB;
    }

    @Override
    public double getDice(String word1, String word2) {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Integer id1 = this.lexicon.getInteger(word1);
            Integer id2 = this.lexicon.getInteger(word2);
            if (id1 == null || id2 == null) {
                return 0.0;
            }
            if (id1 > id2) {
                Integer temp = id1;
                id1 = id2;
                id2 = temp;
            }
            stmt = this.conn.createStatement();
            StringBuffer sb = new StringBuffer();
            sb.append("select * from collocs where w1=");
            sb.append(id1);
            sb.append(" and w2=");
            sb.append(id2);
            rs = stmt.executeQuery(sb.toString());
            if (rs.next()) {
                Double count = rs.getDouble("dice");
                double d = count;
                return d;
            }
            return 0.0;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    @Override
    public long getCount(String word1, String word2) {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Integer id1 = this.lexicon.getInteger(word1);
            Integer id2 = this.lexicon.getInteger(word2);
            if (id1 == null || id2 == null) {
                return 0L;
            }
            if (id1 > id2) {
                Integer temp = id1;
                id1 = id2;
                id2 = temp;
            }
            stmt = this.conn.createStatement();
            StringBuffer sb = new StringBuffer();
            sb.append("select * from collocs where w1=");
            sb.append(id1);
            sb.append(" and w2=");
            sb.append(id2);
            rs = stmt.executeQuery(sb.toString());
            if (rs.next()) {
                Long count = rs.getLong("count");
                long l = count;
                return l;
            }
            return 0L;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    @Override
    public List<Cooccurrence> getBestByDice(String word, int i) throws SQLException {
        ArrayList<Cooccurrence> cooccurs = new ArrayList<Cooccurrence>();
        if (word == null) {
            return cooccurs;
        }
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Lexicon lexicon = MySQLLexicon.getInstance(this.collocsDB);
            Integer wordId = lexicon.getInteger(word);
            if (wordId == null) {
                ArrayList<Cooccurrence> arrayList = cooccurs;
                return arrayList;
            }
            stmt = this.conn.createStatement();
            String query = new StringBuffer().append("select * from collocs where w1=").append(wordId).append(" or w2=").append(wordId).append(" order by dice desc limit " + i).toString();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                Integer i1 = rs.getInt("w1");
                Integer i2 = rs.getInt("w2");
                Long count = rs.getLong("count");
                Double dice = rs.getDouble("dice");
                String w1 = lexicon.getWord(i1);
                String w2 = lexicon.getWord(i2);
                if (!i1.equals(wordId)) {
                    String temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                cooccurs.add(new Cooccurrence(w1, w2, count, dice));
            }
            ArrayList<Cooccurrence> arrayList = cooccurs;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<Cooccurrence> getAllByDice(String word, double minDice) throws SQLException {
        return this.getAllByDiceAndCount(word, minDice, 0L);
    }

    @Override
    public List<Cooccurrence> getAllByDiceAndCount(String word, double minDice, long minCount) throws SQLException {
        ArrayList<Cooccurrence> cooccurs = new ArrayList<Cooccurrence>();
        if (word == null) {
            return cooccurs;
        }
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Lexicon lexicon = MySQLLexicon.getInstance(this.collocsDB);
            Integer wordId = lexicon.getInteger(word);
            if (wordId == null) {
                ArrayList<Cooccurrence> arrayList = cooccurs;
                return arrayList;
            }
            stmt = this.conn.createStatement();
            StringBuffer query = new StringBuffer().append("select * from collocs where (w1=").append(wordId).append(" or w2=").append(wordId).append(") and dice >= " + minDice);
            if (minCount > 0L) {
                query.append(" and count >= ").append(minCount);
            }
            rs = stmt.executeQuery(query.toString());
            while (rs.next()) {
                Integer i1 = rs.getInt("w1");
                Integer i2 = rs.getInt("w2");
                Long count = rs.getLong("count");
                Double dice = rs.getDouble("dice");
                String w1 = lexicon.getWord(i1);
                String w2 = lexicon.getWord(i2);
                if (!i1.equals(wordId)) {
                    String temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                cooccurs.add(new Cooccurrence(w1, w2, count, dice));
            }
            ArrayList<Cooccurrence> arrayList = cooccurs;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<Cooccurrence> getAllCooccurrences(String word, Collection<String> wordSet) throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<Cooccurrence> cooccurs = new ArrayList<Cooccurrence>();
        if (wordSet.size() == 0) {
            return cooccurs;
        }
        try {
            int currWordId;
            Lexicon lexicon = MySQLLexicon.getInstance(this.collocsDB);
            stmt = this.conn.createStatement();
            StringBuffer sb = new StringBuffer();
            int wId = lexicon.getInteger(word);
            sb.append("select * from collocs where ((w1=" + wId);
            boolean bFirst = true;
            for (String currWord : wordSet) {
                currWordId = lexicon.getInteger(currWord);
                if (bFirst) {
                    bFirst = false;
                    sb.append(")&&((w2=" + currWordId + ")");
                    continue;
                }
                sb.append("||(w2=" + currWordId + ")");
            }
            sb.append(")) || ((w2=" + wId);
            bFirst = true;
            for (String currWord : wordSet) {
                currWordId = lexicon.getInteger(currWord);
                if (bFirst) {
                    bFirst = false;
                    sb.append(")&&((w1=" + currWordId + ")");
                    continue;
                }
                sb.append("||(w1=" + currWordId + ")");
            }
            sb.append("));");
            rs = stmt.executeQuery(sb.toString());
            while (rs.next()) {
                Integer i1 = rs.getInt("w1");
                Integer i2 = rs.getInt("w2");
                Long count = rs.getLong("count");
                Double dice = rs.getDouble("dice");
                String w1 = lexicon.getWord(i1);
                String w2 = lexicon.getWord(i2);
                if (!i1.equals(lexicon.getInteger(word))) {
                    String temp = w1;
                    w1 = w2;
                    w2 = temp;
                }
                cooccurs.add(new Cooccurrence(w1, w2, count, dice));
            }
            ArrayList<Cooccurrence> arrayList = cooccurs;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<Cooccurrence> getPairSimilarity(ArrayList<Integer> l) throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Lexicon lexicon = MySQLLexicon.getInstance(this.collocsDB);
            String elementId = "(";
            if (l != null) {
                elementId = "(";
                for (int w : l) {
                    elementId = String.valueOf(elementId) + "'" + w + "', ";
                }
                elementId = String.valueOf(elementId) + " -10)";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select c.* ");
            sb.append("from collocs c ");
            sb.append(" where (c.w1 in " + elementId + ") and (c.w2 in " + elementId + ")");
            sb.append(" order by dice desc ");
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(sb.toString());
            ArrayList<Cooccurrence> cooccurs = new ArrayList<Cooccurrence>();
            while (rs.next()) {
                Integer i1 = rs.getInt("w1");
                Integer i2 = rs.getInt("w2");
                Long count = rs.getLong("count");
                Double dice = rs.getDouble("dice");
                String w1 = lexicon.getWord(i1);
                String w2 = lexicon.getWord(i2);
                cooccurs.add(new Cooccurrence(w1, w2, count, dice));
            }
            ArrayList<Cooccurrence> arrayList = cooccurs;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<Cooccurrence> getAllCooccurrences() throws SQLException {
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<Cooccurrence> cooccurs = new ArrayList<Cooccurrence>();
        Lexicon lexicon = MySQLLexicon.getInstance(this.collocsDB);
        try {
            stmt = this.conn.createStatement();
            StringBuffer sb = new StringBuffer();
            sb.append("select * from collocs");
            rs = stmt.executeQuery(sb.toString());
            while (rs.next()) {
                Integer i1 = rs.getInt("w1");
                Integer i2 = rs.getInt("w2");
                Long count = rs.getLong("count");
                Double dice = rs.getDouble("dice");
                String w1 = lexicon.getWord(i1);
                String w2 = lexicon.getWord(i2);
                cooccurs.add(new Cooccurrence(w1, w2, count, dice));
            }
            ArrayList<Cooccurrence> arrayList = cooccurs;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        MySQLCollocs collocs = MySQLCollocs.getMySQLCollocsInstance(CollocsDB.UKWACCO);
        String referenceWord = "life_on_mars";
        BufferedReader reader = new BufferedReader(new FileReader("/home/dimarco/workspace/IndACo/test.txt"));
        while (reader.ready()) {
            String line = reader.readLine();
            long count = collocs.getCount("life_on_mars", line);
            if (count <= 0L) continue;
            System.out.println("Occorrence tra life_on_mars e " + line + ": " + count);
        }
        reader.close();
    }
}

