/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.Lexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.collocs.enumeration.LexiconField;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnimplementedMethodException;
import it.uniroma1.lcl.jlt.util.ObjectManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class LuceneLexicon
extends Lexicon {
    private Map<String, Long> word2count = new HashMap<String, Long>();
    private static final String LOCATION_SUFFIX = "/lexicon";

    protected static LuceneLexicon getLuceneLexiconInstance(CollocsDB collocsDB) {
        ObjectManager manager = ObjectManager.getInstance();
        if (!manager.contains(LuceneLexicon.class, (Object)collocsDB)) {
            manager.put(LuceneLexicon.class, (Object)collocsDB, new LuceneLexicon(collocsDB));
        }
        return manager.get(LuceneLexicon.class, (Object)collocsDB);
    }

    private LuceneLexicon(CollocsDB collocsDB) {
        this.collocsDB = collocsDB;
        this.load();
    }

    private void load() {
        try {
            SimpleFSDirectory simpleDir = new SimpleFSDirectory(new File(String.valueOf(Configuration.getInstance().getCollocsLocation(this.collocsDB)) + LOCATION_SUFFIX));
            IndexSearcher is = new IndexSearcher((Directory)simpleDir, true);
            WildcardQuery wq = new WildcardQuery(new Term(LexiconField.WORD.toString(), "*"));
            Hits hits = is.search((Query)wq);
            int i = 0;
            while (i < hits.length()) {
                Document currentEntry = hits.doc(i);
                String word = currentEntry.get(LexiconField.WORD.toString());
                Long value = Long.parseLong(currentEntry.get(LexiconField.COUNT.toString()));
                this.word2count.put(word, value);
                ++i;
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCount(String word) {
        if (!this.word2count.containsKey(word)) {
            return 0L;
        }
        return this.word2count.get(word);
    }

    @Override
    public boolean contains(String word) {
        return this.word2count.containsKey(word);
    }

    @Override
    public long size() {
        return this.word2count.size();
    }

    @Override
    public void close() {
        throw new UnimplementedMethodException();
    }

    @Override
    public Integer getInteger(String word) {
        throw new UnimplementedMethodException();
    }

    @Override
    public String getWord(int id) {
        throw new UnimplementedMethodException();
    }

    @Override
    public Set<Integer> getIds() {
        throw new UnimplementedMethodException();
    }

    @Override
    public long getCount(Integer id) {
        throw new UnimplementedMethodException();
    }

    @Override
    public int getId(String word) {
        throw new UnimplementedMethodException();
    }

    @Override
    public Set<String> getLexiconWords() {
        return this.word2count.keySet();
    }

    @Override
    public long getTotalCount() {
        throw new UnimplementedMethodException();
    }
}

