/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.Collocs;
import it.uniroma1.lcl.jlt.collocs.Lexicon;
import it.uniroma1.lcl.jlt.collocs.LuceneLexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsField;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnimplementedMethodException;
import it.uniroma1.lcl.jlt.util.Cooccurrence;
import it.uniroma1.lcl.jlt.util.ObjectManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

public class LuceneCollocs
extends Collocs {
    private IndexSearcher is = null;
    private static final String LOCATION_SUFFIX = "/collocs";

    protected static LuceneCollocs getLuceneCollocsInstance(CollocsDB collocsDB) {
        ObjectManager manager = ObjectManager.getInstance();
        if (!manager.contains(LuceneCollocs.class, (Object)collocsDB)) {
            manager.put(LuceneCollocs.class, (Object)collocsDB, new LuceneCollocs(collocsDB));
        }
        return manager.get(LuceneCollocs.class, (Object)collocsDB);
    }

    private LuceneCollocs(CollocsDB collocsDB) {
        this.collocsDB = collocsDB;
        try {
            SimpleFSDirectory simpleDir = new SimpleFSDirectory(new File(String.valueOf(Configuration.getInstance().getCollocsLocation(collocsDB)) + LOCATION_SUFFIX));
            this.is = new IndexSearcher((Directory)simpleDir, true);
            this.collocsDB = collocsDB;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCount(String word1, String word2) {
        long count = new Double(this.getFieldValue(word1, word2, CollocsField.CO_OCCURR.toString())).longValue();
        return count;
    }

    @Override
    public double getDice(String word1, String word2) {
        return this.getFieldValue(word1, word2, CollocsField.DICE.toString());
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double getFieldValue(String word1, String word2, String fieldName) {
        try {
            BooleanQuery query = new BooleanQuery();
            Term[] terms = new Term[]{new Term(CollocsField.WORD1.toString(), word1), new Term(CollocsField.WORD2.toString(), word2)};
            query.add(new BooleanClause((Query)new TermQuery(terms[0]), BooleanClause.Occur.MUST));
            query.add(new BooleanClause((Query)new TermQuery(terms[1]), BooleanClause.Occur.MUST));
            int[] docFreqs = this.is.docFreqs(terms);
            int maxHits = docFreqs[0] + docFreqs[1];
            TopDocs results = this.is.search((Query)query, maxHits);
            if (results.totalHits == 1) {
                Document doc = this.is.doc(results.scoreDocs[0].doc);
                Double returnValue = Double.parseDouble(doc.get(fieldName));
                return returnValue;
            }
            if (results.totalHits > 1) {
                throw new RuntimeException("Malformed Index");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Override
    public CollocsDB getCollocsDB() {
        return this.collocsDB;
    }

    @Override
    public List<Cooccurrence> getBestByDice(String word, int maxHits) throws SQLException {
        ArrayList<Cooccurrence> resultList = new ArrayList<Cooccurrence>();
        try {
            BooleanQuery query = new BooleanQuery();
            Term[] terms = new Term[]{new Term(CollocsField.WORD1.toString(), word), new Term(CollocsField.WORD2.toString(), word)};
            query.add(new BooleanClause((Query)new TermQuery(terms[0]), BooleanClause.Occur.SHOULD));
            query.add(new BooleanClause((Query)new TermQuery(terms[1]), BooleanClause.Occur.SHOULD));
            Filter filter = null;
            Sort sorter = new Sort(new SortField(CollocsField.DICE.toString(), 7, true));
            TopFieldDocs results = this.is.search((Query)query, filter, maxHits, sorter);
            ScoreDoc[] scoreDocArray = results.scoreDocs;
            int n = results.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.is.doc(scoreDoc.doc);
                String word1 = doc.get(CollocsField.WORD1.toString());
                String word2 = doc.get(CollocsField.WORD2.toString());
                double dice = Double.parseDouble(doc.get(CollocsField.DICE.toString()));
                long count = Long.parseLong(doc.get(CollocsField.CO_OCCURR.toString()));
                resultList.add(new Cooccurrence(word1, word2, count, dice));
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public List<Cooccurrence> getAllByDice(String word, double minDice) throws SQLException {
        ArrayList<Cooccurrence> resultList = new ArrayList<Cooccurrence>();
        try {
            BooleanQuery query = new BooleanQuery();
            Term[] terms = new Term[]{new Term(CollocsField.WORD1.toString(), word), new Term(CollocsField.WORD2.toString(), word)};
            query.add(new BooleanClause((Query)new TermQuery(terms[0]), BooleanClause.Occur.SHOULD));
            query.add(new BooleanClause((Query)new TermQuery(terms[1]), BooleanClause.Occur.SHOULD));
            int[] docFreqs = this.is.docFreqs(terms);
            int maxHits = docFreqs[0] + docFreqs[1];
            TopDocs results = this.is.search((Query)query, maxHits);
            ScoreDoc[] scoreDocArray = results.scoreDocs;
            int n = results.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.is.doc(scoreDoc.doc);
                double dice = Double.parseDouble(doc.get(CollocsField.DICE.toString()));
                if (dice >= minDice) {
                    String word1 = doc.get(CollocsField.WORD1.toString());
                    String word2 = doc.get(CollocsField.WORD2.toString());
                    long count = Long.parseLong(doc.get(CollocsField.CO_OCCURR.toString()));
                    resultList.add(new Cooccurrence(word1, word2, count, dice));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public List<Cooccurrence> getAllByDiceAndCount(String word, double minDice, long minCount) throws SQLException {
        ArrayList<Cooccurrence> resultList = new ArrayList<Cooccurrence>();
        try {
            BooleanQuery query = new BooleanQuery();
            Term[] terms = new Term[]{new Term(CollocsField.WORD1.toString(), word), new Term(CollocsField.WORD2.toString(), word)};
            query.add(new BooleanClause((Query)new TermQuery(terms[0]), BooleanClause.Occur.SHOULD));
            query.add(new BooleanClause((Query)new TermQuery(terms[1]), BooleanClause.Occur.SHOULD));
            int[] docFreqs = this.is.docFreqs(terms);
            int maxHits = docFreqs[0] + docFreqs[1];
            TopDocs results = this.is.search((Query)query, maxHits);
            ScoreDoc[] scoreDocArray = results.scoreDocs;
            int n = results.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.is.doc(scoreDoc.doc);
                double dice = Double.parseDouble(doc.get(CollocsField.DICE.toString()));
                long count = Long.parseLong(doc.get(CollocsField.CO_OCCURR.toString()));
                if (dice >= minDice && count >= minCount) {
                    String word1 = doc.get(CollocsField.WORD1.toString());
                    String word2 = doc.get(CollocsField.WORD2.toString());
                    resultList.add(new Cooccurrence(word1, word2, count, dice));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public List<Cooccurrence> getAllCooccurrences(String word, Collection<String> wordSet) throws SQLException {
        ArrayList<Cooccurrence> resultList = new ArrayList<Cooccurrence>();
        try {
            BooleanQuery query = new BooleanQuery();
            Term[] terms = new Term[]{new Term(CollocsField.WORD1.toString(), word), new Term(CollocsField.WORD2.toString(), word)};
            query.add(new BooleanClause((Query)new TermQuery(terms[0]), BooleanClause.Occur.SHOULD));
            query.add(new BooleanClause((Query)new TermQuery(terms[1]), BooleanClause.Occur.SHOULD));
            int[] docFreqs = this.is.docFreqs(terms);
            int maxHits = docFreqs[0] + docFreqs[1];
            TopDocs res = this.is.search((Query)query, maxHits);
            ScoreDoc[] scoreDocArray = res.scoreDocs;
            int n = res.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.is.doc(scoreDoc.doc);
                String word1 = doc.get(CollocsField.WORD1.toString());
                String word2 = doc.get(CollocsField.WORD2.toString());
                double dice = Double.parseDouble(doc.get(CollocsField.DICE.toString()));
                long count = Long.parseLong(doc.get(CollocsField.CO_OCCURR.toString()));
                if (wordSet.contains(word1) || wordSet.contains(word2)) {
                    resultList.add(new Cooccurrence(word1, word2, count, dice));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public List<Cooccurrence> getAllCooccurrences() throws SQLException {
        throw new RuntimeException("Metodo ancora non implementato per Collocs DB basati su Lucene");
    }

    @Override
    public List<Cooccurrence> getPairSimilarity(ArrayList<Integer> l) throws SQLException {
        throw new UnimplementedMethodException();
    }

    public static void main(String[] args) throws SQLException, IOException {
        Collocs collocs = LuceneCollocs.getInstance(CollocsDB.SEMEVAL10_TRAIN);
        Lexicon lexicon = LuceneLexicon.getInstance(CollocsDB.SEMEVAL10_TRAIN);
        int count = 0;
        System.out.println("Ho " + lexicon.getLexiconWords().size() + " da analizzare");
        double soglia = 0.01;
        List<Cooccurrence> topRAM = collocs.getAllByDice("random_access_memory", soglia);
        List<Cooccurrence> topComputer = collocs.getAllByDice("computer", soglia);
        List<Cooccurrence> topToday = collocs.getAllByDice("today", soglia);
        FileWriter ramWriter = new FileWriter("ram.txt");
        for (Cooccurrence c : topRAM) {
            if (c.getWord1().equals("random_access_memory")) {
                ramWriter.write(String.valueOf(c.getWord2()) + " -- " + c.getDice() + "\n");
                continue;
            }
            ramWriter.write(String.valueOf(c.getWord1()) + " -- " + c.getDice() + "\n");
        }
        ramWriter.flush();
        ramWriter.close();
        FileWriter compWriter = new FileWriter("computer.txt");
        for (Cooccurrence c : topComputer) {
            if (c.getWord1().equals("computer")) {
                compWriter.write(String.valueOf(c.getWord2()) + " -- " + c.getDice() + "\n");
                continue;
            }
            compWriter.write(String.valueOf(c.getWord1()) + " -- " + c.getDice() + "\n");
        }
        compWriter.flush();
        compWriter.close();
        FileWriter today = new FileWriter("today.txt");
        for (Cooccurrence c : topToday) {
            if (c.getWord1().equals("today")) {
                today.write(String.valueOf(c.getWord2()) + " -- " + c.getDice() + "\n");
                continue;
            }
            today.write(String.valueOf(c.getWord1()) + " -- " + c.getDice() + "\n");
        }
        today.flush();
        today.close();
        System.out.println("gli elementi sono: " + count);
    }
}

