/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.LuceneLexicon;
import it.uniroma1.lcl.jlt.collocs.MySQLLexicon;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnknownDBException;
import java.util.Set;

public abstract class Lexicon {
    protected static Configuration config = Configuration.getInstance();
    protected CollocsDB collocsDB;

    public static Lexicon getInstance(CollocsDB usedDB) {
        if (usedDB.isMySQLDB()) {
            return MySQLLexicon.getMySQLLexiconInstance(usedDB);
        }
        if (usedDB.isLuceneDB()) {
            return LuceneLexicon.getLuceneLexiconInstance(usedDB);
        }
        throw new UnknownDBException();
    }

    public static Lexicon getInstance() {
        return Lexicon.getInstance(Configuration.getInstance().getCollocsDB());
    }

    public abstract long getCount(String var1);

    public abstract int getId(String var1);

    public abstract boolean contains(String var1);

    public abstract long size();

    public abstract void close();

    public abstract long getTotalCount();

    public abstract Integer getInteger(String var1);

    public abstract String getWord(int var1);

    public abstract Set<Integer> getIds();

    public abstract long getCount(Integer var1);

    public abstract Set<String> getLexiconWords();
}

