/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.collocs;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.collocs.LuceneCollocs;
import it.uniroma1.lcl.jlt.collocs.MySQLCollocs;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnknownDBException;
import it.uniroma1.lcl.jlt.util.Cooccurrence;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Collocs {
    protected static Configuration config = Configuration.getInstance();
    protected CollocsDB collocsDB;

    public static Collocs getInstance(CollocsDB usedDB) {
        if (usedDB.isMySQLDB()) {
            return MySQLCollocs.getMySQLCollocsInstance(usedDB);
        }
        if (usedDB.isLuceneDB()) {
            return LuceneCollocs.getLuceneCollocsInstance(usedDB);
        }
        throw new UnknownDBException();
    }

    public static Collocs getInstance() {
        return Collocs.getInstance(Configuration.getInstance().getCollocsDB());
    }

    public abstract long getCount(String var1, String var2);

    public abstract double getDice(String var1, String var2);

    public abstract void close();

    public abstract CollocsDB getCollocsDB();

    public abstract List<Cooccurrence> getBestByDice(String var1, int var2) throws SQLException;

    public abstract List<Cooccurrence> getAllByDice(String var1, double var2) throws SQLException;

    public abstract List<Cooccurrence> getAllByDiceAndCount(String var1, double var2, long var4) throws SQLException;

    public abstract List<Cooccurrence> getAllCooccurrences(String var1, Collection<String> var2) throws SQLException;

    public abstract List<Cooccurrence> getAllCooccurrences() throws SQLException;

    public abstract List<Cooccurrence> getPairSimilarity(ArrayList<Integer> var1) throws SQLException;
}

