/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.bnc;

import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import it.uniroma1.lcl.jlt.bnc.StanfordTriple;
import it.uniroma1.lcl.jlt.collocs.exceptions.UnimplementedMethodException;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import it.uniroma1.lcl.jlt.util.Files;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StanfordParsedCorpusIterator
implements Iterator<StanfordTriple> {
    protected static final Log log = LogFactory.getLog(StanfordParsedCorpusIterator.class);
    private static final String DEPENDENCY_REGEX = "(.*)\\((.*), (.*)\\)";
    private static final Pattern pattern = Pattern.compile("(.*)\\((.*), (.*)\\)");
    private boolean bLoadStanfordSentences;
    private boolean bLoadParseTrees;
    private boolean bLoadSyntacticDependencies;
    private BufferedReader reader;
    private StanfordTriple next;
    private int sentenceNumber = 0;

    public StanfordParsedCorpusIterator(String file) {
        this(file, true, true, true);
    }

    public StanfordParsedCorpusIterator(String file, boolean bLoadStanfordSentences, boolean bLoadParseTrees, boolean bLoadSyntacticDependencies) {
        try {
            this.reader = Files.getBufferedReader(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bLoadStanfordSentences = bLoadStanfordSentences;
        this.bLoadParseTrees = bLoadParseTrees;
        this.bLoadSyntacticDependencies = bLoadSyntacticDependencies;
        this.next = this.readNext();
    }

    private StanfordTriple readNext() {
        String dependencyException;
        String first;
        ArrayList<TypedDependency> dependencies;
        Tree parseTree;
        StanfordSentence sentence;
        block10: {
            sentence = null;
            parseTree = null;
            dependencies = new ArrayList<TypedDependency>();
            first = null;
            dependencyException = null;
            first = this.reader.readLine();
            if (first != null) break block10;
            return null;
        }
        try {
            ++this.sentenceNumber;
            String second = this.reader.readLine();
            String third = this.reader.readLine();
            if (this.bLoadStanfordSentences) {
                sentence = StanfordSentence.fromLine(first, "\t");
            }
            if (this.bLoadParseTrees) {
                parseTree = Tree.valueOf((String)second);
            }
            if (this.bLoadSyntacticDependencies && !third.isEmpty()) {
                String[] deps;
                String[] stringArray = deps = third.split("\t");
                int n = deps.length;
                int n2 = 0;
                while (n2 < n) {
                    String dependency;
                    dependencyException = dependency = stringArray[n2];
                    Matcher matcher = pattern.matcher(dependency);
                    if (!matcher.find()) {
                        log.error((Object)("Error while applying the regex (.*)\\((.*), (.*)\\) to " + third));
                    }
                    GrammaticalRelation reln = GrammaticalRelation.valueOf((String)matcher.group(1));
                    log.debug((Object)("RELN:" + reln));
                    Pair<String, String> govPair = Strings.splitToPairWithLastIndex(matcher.group(2), "-");
                    CyclicCoreLabel govLabel = new CyclicCoreLabel();
                    govLabel.setValue(govPair.getFirst());
                    govLabel.setIndex(new Integer(govPair.getSecond()).intValue());
                    TreeGraphNode gov = new TreeGraphNode((Label)govLabel);
                    log.debug((Object)("GOV:" + gov));
                    Pair<String, String> depPair = Strings.splitToPairWithLastIndex(matcher.group(3), "-");
                    CyclicCoreLabel depLabel = new CyclicCoreLabel();
                    depLabel.setValue(depPair.getFirst());
                    depLabel.setIndex(new Integer(depPair.getSecond()).intValue());
                    TreeGraphNode dep = new TreeGraphNode((Label)depLabel);
                    log.debug((Object)("DEP:" + dep));
                    TypedDependency typedDependency = new TypedDependency(reln, gov, dep);
                    log.debug((Object)("TYPED-DEP:" + typedDependency));
                    dependencies.add(typedDependency);
                    ++n2;
                }
            }
        }
        catch (NumberFormatException e) {
            log.debug((Object)("Found apostrophed index in relation: " + dependencyException + " at sentence no. " + this.sentenceNumber + ": " + first));
        }
        catch (IllegalStateException e) {
            log.debug((Object)("Could not apply the pattern matcher at sentence no. " + this.sentenceNumber + ": " + first));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new StanfordTriple(sentence, parseTree, dependencies);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public StanfordTriple next() {
        StanfordTriple toReturn = this.next;
        this.next = this.readNext();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new UnimplementedMethodException();
    }
}

