/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.bnc;

import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.UnorderedPair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cooccurrences
implements Iterable<UnorderedPair<String>> {
    protected IntegerCounter<UnorderedPair<String>> counter = new IntegerCounter();

    public Cooccurrences() {
    }

    public Cooccurrences(String filename) throws NumberFormatException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = "";
        String REGEX = "<(.*), (.*)> (\\d+)";
        Pattern p = Pattern.compile(REGEX);
        while ((line = br.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            String w1 = m.group(1);
            String w2 = m.group(2);
            Integer count = new Integer(m.group(3));
            this.counter.count(new UnorderedPair<String>(w1, w2), count);
        }
        br.close();
    }

    @Override
    public Iterator<UnorderedPair<String>> iterator() {
        return this.counter.keySet().iterator();
    }

    public void addCooccurrence(UnorderedPair<String> pair) {
        this.counter.count(pair);
    }

    public void addCooccurrence(UnorderedPair<String> pair, int k) {
        this.counter.count(pair, k);
    }

    public void merge(Cooccurrences occ) {
        this.counter.addFrom(occ.counter);
    }

    public int getCount(UnorderedPair<String> o) {
        return (Integer)this.counter.get(o);
    }

    public int getTotalWithoutRepetitions() {
        return this.counter.size();
    }

    public double getTotal() {
        return this.counter.getTotal();
    }

    public IntegerCounter<String> getLexicon() {
        IntegerCounter<String> lexicon = new IntegerCounter<String>();
        for (UnorderedPair<String> occurrence : this) {
            int count = (Integer)this.counter.get(occurrence);
            if (((String)occurrence.getFirst()).equals(occurrence.getSecond())) {
                lexicon.count((String)occurrence.getFirst(), count);
                continue;
            }
            lexicon.count((String)occurrence.getFirst(), count);
            lexicon.count((String)occurrence.getSecond(), count);
        }
        return lexicon;
    }
}

