/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.bnc;

import it.uniroma1.lcl.jlt.bnc.BncSentence;
import it.uniroma1.lcl.jlt.bnc.Cooccurrences;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BncText
implements Iterable<BncSentence> {
    private String id;
    private String title;
    private String domain;
    private ArrayList<String> keyWords;
    private String medium;
    private String category;
    private BNC_DOCUMENT type;
    private List<BncSentence> sentences;

    public BncText(String id) {
        this.id = id;
        this.sentences = new ArrayList<BncSentence>();
        this.keyWords = new ArrayList();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addSentence(BncSentence sentence) {
        this.sentences.add(sentence);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Iterator<BncSentence> iterator() {
        return this.sentences.iterator();
    }

    public ArrayList<String> getKeywords() {
        return this.keyWords;
    }

    public void addKeyword(String keyword) {
        this.keyWords.add(keyword);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String cat) {
        this.category = cat;
    }

    public BNC_DOCUMENT getType() {
        return this.type;
    }

    public void setType(BNC_DOCUMENT type) {
        this.type = type;
    }

    public Set<String> getLexicon(String ... poses) {
        HashSet<String> lexicon = new HashSet<String>();
        for (BncSentence sentence : this) {
            lexicon.addAll(sentence.getLexicon(poses));
        }
        return lexicon;
    }

    public IntegerCounter<String> getLexiconWithCounts(String ... poses) {
        IntegerCounter<String> lexicon = new IntegerCounter<String>(this.getId());
        for (BncSentence sentence : this) {
            lexicon.addFrom(sentence.getLexiconWithCounts(poses));
        }
        return lexicon;
    }

    public Cooccurrences getCooccurrences() {
        Cooccurrences cooccurrences = new Cooccurrences();
        for (BncSentence sentence : this) {
            cooccurrences.merge(sentence.getCooccurrences());
        }
        return cooccurrences;
    }

    protected static enum BNC_DOCUMENT {
        SPOKEN,
        WRITTEN;

    }
}

