/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.bnc;

import edu.stanford.nlp.ling.WordLemmaTag;
import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.bnc.Cooccurrences;
import it.uniroma1.lcl.jlt.pipeline.stanford.StanfordSentence;
import it.uniroma1.lcl.jlt.util.IntegerCounter;
import it.uniroma1.lcl.jlt.util.UnorderedPair;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BncSentence
extends StanfordSentence {
    private static final long serialVersionUID = -5042292132061675414L;
    private static final Log log = LogFactory.getLog(BncSentence.class);
    protected String ID;

    public BncSentence(String ID) throws IOException {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public Set<String> getLexicon(String ... poses) {
        HashSet<String> lexicon = new HashSet<String>();
        block0: for (WordLemmaTag word : this) {
            if (poses == null) {
                lexicon.add(String.valueOf(word.lemma()) + "#" + word.tag());
                continue;
            }
            String[] stringArray = poses;
            int n = poses.length;
            int n2 = 0;
            while (n2 < n) {
                String pos = stringArray[n2];
                if (pos.equals(word.tag())) {
                    lexicon.add(String.valueOf(word.lemma()) + "#" + word.tag());
                    continue block0;
                }
                ++n2;
            }
        }
        return lexicon;
    }

    public IntegerCounter<String> getLexiconWithCounts(String ... poses) {
        IntegerCounter<String> lexicon = new IntegerCounter<String>();
        block0: for (WordLemmaTag word : this) {
            if (poses.length == 0) {
                lexicon.count(String.valueOf(word.lemma()) + "#" + word.tag());
                continue;
            }
            String[] stringArray = poses;
            int n = poses.length;
            int n2 = 0;
            while (n2 < n) {
                String pos = stringArray[n2];
                if (pos.equals(word.tag())) {
                    lexicon.count(String.valueOf(word.lemma()) + "#" + word.tag());
                    continue block0;
                }
                ++n2;
            }
        }
        return lexicon;
    }

    public Cooccurrences getCooccurrences() {
        log.debug((Object)("Sentence (lemmas only): " + this.toLemmaString()));
        log.debug((Object)("Sentence (with PoS): " + this.toString()));
        log.debug((Object)("|Sentence| = " + this.getWords().size()));
        Cooccurrences cooccurrences = new Cooccurrences();
        WordLemmaTag[] wordArray = this.getWords().toArray(new WordLemmaTag[0]);
        int width = Configuration.getInstance().getBncCooccurrenceWindow();
        log.debug((Object)("Window size: " + width));
        int i = 0;
        while (i < wordArray.length) {
            WordLemmaTag w1 = wordArray[i];
            String word1 = String.valueOf(w1.lemma()) + "#" + w1.tag();
            log.debug((Object)("First word = " + word1));
            int right = Math.min(wordArray.length - 1, i + width);
            int j = i + 1;
            while (j <= right) {
                WordLemmaTag w2 = wordArray[j];
                String word2 = String.valueOf(w2.lemma()) + "#" + w2.tag();
                log.debug((Object)("\tSecond word = " + word2));
                cooccurrences.addCooccurrence(new UnorderedPair<String>(word1, word2));
                ++j;
            }
            ++i;
        }
        log.debug((Object)("Cooccurrences: " + cooccurrences));
        return cooccurrences;
    }

    public String toPoSstring() {
        String sentence = "";
        for (WordLemmaTag w : this) {
            sentence = String.valueOf(sentence) + w.word() + "/" + w.tag() + " ";
        }
        return sentence;
    }
}

