/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.bnc;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.minipar.MiniparSentence;
import it.uniroma1.lcl.jlt.util.Files;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BncParsedDumpIterator
implements Iterator<MiniparSentence> {
    protected static final Log log = LogFactory.getLog(BncParsedDumpIterator.class);
    protected static final String bncParsedFullFilePath = String.valueOf(Configuration.getInstance().getBncDirectory()) + "bnc.parsed.minipar.txt";
    protected int sentences = 0;
    protected BufferedReader reader;

    public BncParsedDumpIterator() {
        this(bncParsedFullFilePath);
    }

    public BncParsedDumpIterator(String filepath) {
        try {
            this.reader = Files.getBufferedReader(bncParsedFullFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void skipSentences(int n) {
        int i = 0;
        while (i < n && this.hasNext()) {
            if (this.hasNext()) {
                this.next();
            }
            ++i;
            ++this.sentences;
        }
    }

    public int getCurrentSentenceNumber() {
        return this.sentences;
    }

    @Override
    public boolean hasNext() {
        return this.reader != null;
    }

    @Override
    public MiniparSentence next() {
        MiniparSentence next = null;
        try {
            String sentence = "";
            String line = null;
            while ((line = this.reader.readLine()) != null && !line.startsWith(")")) {
                sentence = line.startsWith("(") ? String.valueOf(line) + "\n" : String.valueOf(sentence) + line + "\n";
            }
            if (line == null) {
                this.reader.close();
                this.reader = null;
            }
            sentence = String.valueOf(sentence) + "\n";
            next = new MiniparSentence(sentence);
            ++this.sentences;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return next;
    }

    @Override
    public void remove() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reader = null;
    }

    public static void main(String[] args) {
        BncParsedDumpIterator bnc = new BncParsedDumpIterator();
        while (bnc.hasNext()) {
            MiniparSentence sentence = bnc.next();
            log.info((Object)(String.valueOf(bnc.getCurrentSentenceNumber()) + ") " + sentence.getOriginalSentence()));
        }
        bnc.remove();
        log.info((Object)("Sentences read: " + bnc.getCurrentSentenceNumber()));
    }
}

