/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.aol.iterator;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.aol.data.AolQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AolQueryLogIterator
implements Iterator<AolQuery> {
    private static final Log log = LogFactory.getLog(AolQueryLogIterator.class);
    private String queryFileDir;
    private InputStreamReader isr;
    private BufferedReader brXMLDump;
    private List<String> queryFiles;
    private Iterator<String> queryFileIterator;
    private AolQuery nextQuery;

    public AolQueryLogIterator() {
        this.init();
    }

    private void init() {
        this.queryFileDir = Configuration.getInstance().getAolQueryDirectory();
        this.queryFiles = new ArrayList<String>();
        log.info((Object)"Files to be parsed:");
        String[] stringArray = new File(this.queryFileDir).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.startsWith("user-ct-test-collection")) {
                this.queryFiles.add(fileName);
                log.info((Object)(String.valueOf(fileName) + " aggiunto"));
            }
            ++n2;
        }
        log.info((Object)"\n");
        this.queryFileIterator = this.queryFiles.iterator();
        this.nextQuery = null;
    }

    public void open() throws IOException {
        this.openNext();
    }

    protected void openNext() throws IOException {
        if (!this.queryFileIterator.hasNext()) {
            return;
        }
        String nextQueryFile = String.valueOf(this.queryFileDir) + "/" + this.queryFileIterator.next();
        this.isr = new InputStreamReader((InputStream)new FileInputStream(nextQueryFile), "UTF-8");
        this.brXMLDump = new BufferedReader(this.isr);
        String firstLine = this.brXMLDump.readLine();
        log.info((Object)("Eliminata la prima riga del file: \"" + firstLine + "\""));
    }

    public void close() throws IOException {
        this.brXMLDump.close();
        this.isr.close();
    }

    @Override
    public boolean hasNext() {
        if (this.nextQuery == null) {
            this.nextQuery = this.next();
        }
        return this.nextQuery != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AolQuery next() {
        if (this.nextQuery != null) {
            AolQuery next = this.nextQuery;
            this.nextQuery = null;
            return next;
        }
        AolQuery query = null;
        try {
            if (this.brXMLDump == null || !this.brXMLDump.ready()) {
                if (!this.queryFileIterator.hasNext()) {
                    return null;
                }
                this.openNext();
            }
            String line = this.brXMLDump.readLine();
            String[] textLine = line.split("\t");
            String querySession = "";
            String queryText = "";
            String queryTime = "";
            String itemRank = "";
            String clickURL = "";
            querySession = textLine[0];
            queryText = textLine[1];
            queryTime = textLine[2];
            if (textLine.length != 5) return new AolQuery(querySession, queryText, queryTime, itemRank, clickURL);
            itemRank = textLine[3];
            clickURL = textLine[4];
            return new AolQuery(querySession, queryText, queryTime, itemRank, clickURL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return query;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported operation 'remove'");
    }

    public void reopen() throws IOException {
        this.isr.close();
        this.brXMLDump.close();
        this.init();
        this.open();
    }

    public static void main(String[] args) throws IOException {
        AolQuery query;
        AolQueryLogIterator iterator = new AolQueryLogIterator();
        iterator.open();
        int i = 0;
        while (i < 4) {
            query = iterator.next();
            System.out.println(query.getQueryText());
            ++i;
        }
        iterator.reopen();
        i = 0;
        while (i < 4) {
            query = iterator.next();
            System.out.println(query.getQueryText());
            ++i;
        }
        iterator.close();
    }
}

