/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma1.lcl.jlt.aol;

import it.uniroma1.lcl.jlt.Configuration;
import it.uniroma1.lcl.jlt.aol.data.AolQuery;
import it.uniroma1.lcl.jlt.aol.iterator.AolQueryLogIterator;
import it.uniroma1.lcl.jlt.collocs.enumeration.CollocsDB;
import it.uniroma1.lcl.jlt.mysql.NumericTableCache;
import it.uniroma1.lcl.jlt.util.Pair;
import it.uniroma1.lcl.jlt.util.Timer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AolQueryLogFactory {
    private static final Log log = LogFactory.getLog(AolQueryLogFactory.class);
    private static final Configuration config = Configuration.getInstance();

    public void saveCountInstructions() throws IOException {
        HashMap<String, Integer> lexiconIDs = new HashMap<String, Integer>();
        NumericTableCache<Pair<Integer, String>, Integer> lexicon = new NumericTableCache<Pair<Integer, String>, Integer>(config.getAolDBName(), config.getCollocsUser(CollocsDB.AOLCO), config.getCollocsPassword(CollocsDB.AOLCO), "lexicon", "id,word", "count");
        NumericTableCache<Pair<Integer, Integer>, Integer> collocs = new NumericTableCache<Pair<Integer, Integer>, Integer>(config.getAolDBName(), config.getCollocsUser(CollocsDB.AOLCO), config.getCollocsPassword(CollocsDB.AOLCO), "collocs", "w1,w2", "count");
        AolQueryLogIterator queryIterator = new AolQueryLogIterator();
        queryIterator.open();
        log.info((Object)"Collecting COUNTS, please wait...");
        long queryCount = 0L;
        Timer timer = new Timer();
        int lastID = 0;
        while (queryIterator.hasNext()) {
            AolQuery query = queryIterator.next();
            while (query.getQueryWords().isEmpty() && queryIterator.hasNext()) {
                query = queryIterator.next();
            }
            for (String string : query.getQueryWords()) {
                if (!lexiconIDs.containsKey(string)) {
                    lexiconIDs.put(string, lastID);
                    ++lastID;
                }
                Pair<Integer, String> idWordPair = new Pair<Integer, String>((Integer)lexiconIDs.get(string), string);
                lexicon.add(idWordPair, 1);
                lexicon.add(new Pair<Integer, String>(-1, "TOTAL_ID"), 1);
            }
            for (Pair pair : query.getWordPairs()) {
                int id2;
                int id1 = (Integer)lexiconIDs.get(pair.getFirst());
                if (id1 < (id2 = ((Integer)lexiconIDs.get(pair.getSecond())).intValue())) {
                    collocs.add(new Pair<Integer, Integer>(id1, id2), 1);
                } else if (id1 > id2) {
                    collocs.add(new Pair<Integer, Integer>(id2, id1), 1);
                } else {
                    throw new RuntimeException("Non possono esistere co-occorrenze di un termine con se stesso");
                }
                collocs.add(new Pair<Integer, Integer>(-1, -1), 1);
            }
            if (++queryCount % 10000L != 0L) continue;
            log.info((Object)(String.valueOf(queryCount) + " query analizzate: " + Timer.getTimeFromMilliseconds(timer.getTime())));
        }
        log.info((Object)("Conteggi calcolati correttamente: " + Timer.getTimeFromMilliseconds(timer.getTime())));
        lexicon.close();
        collocs.close();
    }

    public static void main(String[] args) throws IOException, SQLException {
        new AolQueryLogFactory().saveCountInstructions();
    }
}

