import { css, CSSResultGroup, html, LitElement, TemplateResult } from "lit";
import { customElement, property } from "lit/decorators.js";
import { classMap } from "lit/directives/class-map.js";
import { Appearance } from "./config/appearance-config";

@customElement("mushroom-card")
export class Card extends LitElement {
  @property() public appearance?: Appearance;

  protected render(): TemplateResult {
    return html`
      <div
        class=${classMap({
          container: true,
          horizontal: this.appearance?.layout === "horizontal",
          "no-info":
            this.appearance?.primary_info === "none" &&
            this.appearance?.secondary_info === "none",
          "no-content":
            this.appearance?.primary_info === "none" &&
            this.appearance?.secondary_info === "none" &&
            this.appearance?.icon_type === "none",
        })}
      >
        <slot></slot>
      </div>
    `;
  }

  static get styles(): CSSResultGroup {
    return css`
      :host {
        flex: 1;
        display: flex;
        flex-direction: column;
        margin: calc(-1 * var(--ha-card-border-width, 1px));
      }
      .container {
        display: flex;
        flex-direction: column;
        flex-shrink: 0;
        flex-grow: 0;
        box-sizing: border-box;
        justify-content: space-between;
        height: 100%;
      }
      .container.horizontal {
        flex-direction: row;
      }
      .container.horizontal > ::slotted(*) {
        flex: 1;
        min-width: 0;
      }
      .container.horizontal > ::slotted(*.actions) {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
        padding-left: 0 !important;
        --control-spacing: var(--spacing);
        --control-height: var(--icon-size);
      }
      .container > ::slotted(mushroom-state-item) {
        flex: 1;
      }
      .container.horizontal.no-info > ::slotted(mushroom-state-item) {
        flex: none;
      }
      .container.no-content > ::slotted(mushroom-state-item) {
        display: none;
      }
      .container.no-content > ::slotted(.actions) {
        --control-spacing: var(--spacing);
        --control-height: var(--icon-size);
        padding: var(--control-spacing) !important;
      }
    `;
  }
}
