# PHP must watch

1. [Basics](#basics)
2. [General](#general)
3. [Architecture and Design](#architecture-and-design)
4. [Performance and Scalability](#performance-and-scalability)
5. [Security](#security)
6. [Testing](#testing)
7. [Frameworks](#frameworks)
8. [Others](#others)
9. [Advanced](#advanced)

A list of interesting conference talks and great videos on PHP. Inspired by [js-must-watch](https://github.com/bolshchikov/js-must-watch)

Suggestions and contributions are welcome, please read the [contributing guidelines](CONTRIBUTING.md).

### Basics

* [**Composer, Autoloading, Namespacing, and PHPUnit**](https://www.youtube.com/watch?v=84j61_aI0q8) - Tuts+ Code `[23:53]`
* [**Clean Code I: Arguments**](https://vimeo.com/13439458) - Uncle Bob, not PHP-specific `[53:33]`
* [**Clean Code II: Functions**](https://vimeo.com/12643301) - Uncle Bob, not PHP-specific `[51:30]`

[Back to top](#php-must-watch)

### General
* [**PHPCraft SouthAfrica Keynote 2014**](https://www.youtube.com/watch?v=hPV6fEjoYq8) - Rasmus Lerdorf `[1:00:43]`
* [**It Was Like That When I Got Here: Steps Toward Modernizing a Legacy Codebase**](https://www.youtube.com/watch?v=65NrzJ_5j58) - Paul M. Jones at Nashville PHP `[47:44]`
* [**My Take on PHP**](https://www.youtube.com/watch?v=gpNbmEnRLBU) - Fabien Potencier at dotScale 2014 `[18:19]`
* [**The Modern Developer Toolbox**](https://www.youtube.com/watch?v=VHkIc329Idw) - Pablo Godel at PHPNW14 `[49:55]`
* [**PHP-FIG:History and Future**](https://www.youtube.com/watch?v=Gp9oSfSfr5I) - Phil Sturgeon at PHP CRAFT SouthAfrica 2014 `[1:05:01]`
* [**PHP 5.NEXT: The New Bits**](https://www.youtube.com/watch?v=zX_U5mymWAg) - Davey Shafik at PHP UK Conference 2014 `[42:40]`
* [**Your (coding) standards matter**](https://www.youtube.com/watch?v=GQiUpjiyer0) - Volker Dusch at PHPNW13 `[45:00]`
* [**HHVM in 2014**](https://www.youtube.com/watch?v=5i7WTvqH0ls) - Elizabeth Smith at php[tek] 2014 `[58:58]`
* [**In Depth Composer**](https://www.youtube.com/watch?v=q3UfxubW_PU) - Jordi Boggiano at Laracon EU 2013 `[46:49]`
* [**HTTP and Your Angry Dog**](https://www.youtube.com/watch?v=2qBaMsYXtJ4) - Ross Tuck at Laracon 2013 `[52:14]`
* [**Introduction to NoSQL**](https://www.youtube.com/watch?v=qI_g07C_Q5I) - Martin Fowler at GOTO Conference 2013 `[54:51]`
* [**Vagrant Provisioners In A Nutshell**](https://www.youtube.com/watch?v=x7iA4yzDsAg) - Erika Heidi at PHP UK Conference 2014 `[47:01]`
* [**Debugging: Past, Present and Future**](https://www.youtube.com/watch?v=5mRk2bE7BAQ) - Derick Rethans at PHPNW14 `[45:09]`
* [**0x0F Ways to be a Better Developer**](https://www.youtube.com/watch?v=FPe3Ij3hXgs) - Lorna Mitchell & Ivo Jansch at PHPNW13 `[40:02]`
* [**Your code sucks, let's fix it**](https://www.youtube.com/watch?v=H2AvoAzbGOE) - Rafael Dohms at Kings of Code Festival 2012 `[47:24]`
* [**Ansible Orchestrate your Infrastructure**](https://vimeo.com/107895274) - Jeremy Coates at PHP Day 2014 `[52:37]`

[Back to top](#php-must-watch)

###  Architecture and Design
* [**Elastic scaling in a (micro)service oriented architecture**](https://www.youtube.com/watch?v=YBDscJhz2S0) - Bastian Hofmann at PHP UK Conference 2016 `[1:02:24]`
* [**Inheritance, Polymorphism, & Testing** - Misko Hevery, Clean Code Talks 2008](https://www.youtube.com/watch?v=4F72VULWFvc) `[38:24]`
* [**Global State & Singletons** - Misko Hevery, Clean Code Talks 2008](https://www.youtube.com/watch?v=-FRm3VPhseI) `[54:08]`
* [**Don't be STUPID, Grasp SOLID** - Anthony Ferrara at PHPNW13](https://www.youtube.com/watch?v=KHBrDWIKW8Q) `[32:30]`
* [**Keynote: Architecture the Lost Years** - Uncle Bob, Ruby Midwest 2011](https://www.youtube.com/watch?v=WpkDN78P884) `[1:06:38]`
* [**Hexagonal Architecture** - Chris Fidao at Laracon 2014](https://www.youtube.com/watch?v=6SBjKOwVq0o) `[38:43]`
* [**Unbreakable Domain Models** - Mathias Verraes at PHP UK Conference 2014](https://www.youtube.com/watch?v=ZJ63ltuwMaE) `[1:03:25]`
* [**Practical Event Sourcing** - Mathias Verraes at phpDay 2014](https://vimeo.com/104095245) `[43:38]`
* [**Decoupling the Model from the Framework** - Mathias Verraes at Laracon 2014](https://www.youtube.com/watch?v=QaIGN_cTcc8) `[53:35]`
* [**API Design: It's Not Rocket Surgery** - Dave Ingram at PHP UK 2013](https://www.youtube.com/watch?v=aoiaSkRCObY) `[36:40]`
* [**The Template Is Not The View: A Brief Introduction to Action-Domain-Responder** - Paul M. Jones at Nomad PHP](https://www.youtube.com/watch?v=rlrTyN0aqSk) `[12:56]`
* [**Action-Domain-Responder** - Paul M. Jones](https://vimeo.com/106771285) `[52:33]`
* [**Designing HTTP Interfaces And RESTful Web Services** - David Zuelke at SymfonyLive Paris 2012](https://www.youtube.com/watch?v=XzgCzjMdvRE) `[1:00:54]`
* [**Web Frontend, API Backend** - Lorna Mitchell at PHPNW14](https://www.youtube.com/watch?v=AdX0q3-4Mfw) `[45:42]`
* [**RESTing with Symfony 2** - Lukas Kahwe Smith at Symfony Camp](https://www.youtube.com/watch?v=Kkby5fG89K0) `[56:52]`
* [**PHP Annotations: They Exist!** - Rafael Dohms at Laracon 2014](https://www.youtube.com/watch?v=oDVspbFgDCo) `[49:48]`
* [**Aphorisms of API Design** - Larry Garfield at Forum PHP 2013](https://www.youtube.com/watch?v=NVcG8ZJdRYs) `[43:54]`
* [**Asynchronous PHP** - Christopher Pitt at PHP CRAFT SouthAfrica 2014](https://www.youtube.com/watch?v=kcjSVab5EhE) `[47:39]`
* [**GOTO Conference Keynote - Microservices** - Martin Fowler](https://www.youtube.com/watch?v=wgdBVIX9ifA) `[26:25]`
* [**Practical Refactoring** - Stefan Koopmanschap at PHPNW14](https://www.youtube.com/watch?v=Peoy8aHIEzc) `[52:27]`
* [**Introducing Dependency Injection** - Rob Allen at PHPNW13](https://www.youtube.com/watch?v=ElnqUIjLWVk) `[39:40]`
* [**Don’t screw it up, how to build durable web APIs** - Alessandro Cinelli and Alessandro Nadalin at PHP Day 2014](https://vimeo.com/104905550) `[45:39]`
* [**Beyond Design Patterns** - Anthony Ferrara at PHPNW14](https://www.youtube.com/watch?v=JV7fiM8r3nc) `[49:23]`
* [**Principles of Agile Design** - Uncle Bob, not-PHP specifc](http://www.infoq.com/presentations/principles-agile-oo-design) `[29:35]`
* [**Beyond Frameworks** - Stewart Stuart Herbert at PHP UK Conferences](https://vimeo.com/21145583) `[49:52]`

[Back to top](#php-must-watch)

### Performance and Scalability
* [**High Performance PHP** - Anthony Ferrara at PHPNW14](https://www.youtube.com/watch?v=qjYyC47rdVs) `[44:38]`
* [**Caching Best Practices** - Eli White at PHP UK 2014](https://www.youtube.com/watch?v=bsZQcbBcXuQ) `[1:03:29]`
* [**Scaling PHP in the Real World** - Dustin Whittle at PHP CRAFT SouthAfrica 2014](https://www.youtube.com/watch?v=fXzWo2xpGS0) `[33:35]`
* [**Scaling e-commerce with PHP** - Simonas Šerlinskas at High Load Strategy 2015](https://vimeo.com/118899410) `[30:14]`
* [**Processing events at scale** - Mariusz Gil at High Load Strategy 2015](https://vimeo.com/118903254) `[29:17]`
* [**Profiling PHP Applications** - Bastian Hofmann at PHP UK 2014](https://www.youtube.com/watch?v=4TbxHDSDkiw) `[1:03:44]`
* [**Bottleneck Analysis** - Ilia Alshanetsky at PHP UK Conference 2013](https://www.youtube.com/watch?v=f8zACyZAE9s) `[50:28]`
* [**Scaling a High Traffic Web Application: Our Journey from Java to PHP** - Dr. Aris Zakinthinos, 2012](https://www.youtube.com/watch?v=oS1D1W6eTwg) `[1:18:37]`

[Back to top](#php-must-watch)

### Security
* [**Web Security And You** - Eli White at PHP UK Conference 2014](https://www.youtube.com/watch?v=ROlhsYQH3qY) `[1:04:23]`
* [**Security Is Not a Feature, It's a State of Mind** - Elizabeth Smith at php[tek] 2014](https://www.youtube.com/watch?v=_kDL-ZhIOzA) `[1:06:50]`
* [**Understanding the OWASP** - Gary Hockin at PHPNW14](https://www.youtube.com/watch?v=MqFBn6oDh-U) `[44:09]`
* [**Password Storage (And Hacking) in PHP** - Anthony Ferrara at PHP Benelux Conference 2013](https://www.youtube.com/watch?v=T4NTdRvIrdk) `[39:30]`
* [**Application Logic Security** - Ilia Alshanetsky at PHPBenelux 2013](https://www.youtube.com/watch?v=cOpDDPV7uoA) `[54:09]`

[Back to top](#php-must-watch)

### Testing
* [**PHPUnit Best Practices** - Sebastian Bergmann at Atlanta PHP UG](https://vimeo.com/63492364) `[1:01:55]`
* [**Emergent Design with PhpSpec** - Marcello Duarte at  phpDay 2014](https://vimeo.com/104905612) `[49:34]`
* [**Using PhpSpec to build quality into a Symfony app** - Jakub Zalas at SymfonyLive London 2013](https://www.youtube.com/watch?v=zSrwu0uQ1VQ) `[40:53]`
* [**Design How Your Objects Talk Through Mocking** - Konstantin Kudryashov at Laracon EU 2014](https://www.youtube.com/watch?v=X6y-OyMPqfw) `[1:00:40]`
* [**Codeception, because tests can have frameworks too!** - Luka Mužinić at phpDay 2014](https://vimeo.com/106388448) `[25:15]`
* [**Behat v3! Behavioral-Driven-De­velopment, Functional Tests and Selenium**- Ryan Weaver at GrPhpDev 2014](https://www.youtube.com/watch?v=0F7-Rr4s9is) `[1:04:23]`
* [**Test, Transform, Refactor** - Marcello Duarte at PHP UK Conference 2014](https://www.youtube.com/watch?v=yPX3gZ7xgN8) `[52:28]`
* [**Unit Testing** - Misko Hevery, Clean Code Talks](https://www.youtube.com/watch?v=wEhu57pih5w) `[32:07]`
* [**Don't Look For Things** - Misko Hevery, Clean Code Talks 2008](https://www.youtube.com/watch?v=RlfLCWKxHJ0) `[37:56]`
* [**Test Driven Laravel form scratch** - Adam Wathan, ZendCon 2016](https://vimeo.com/151390908) `[26:39]`

[Back to top](#php-must-watch)

### Frameworks
* [**Silex Anatomy** - Igor Wiedler at PHP Benelux 2013](https://www.youtube.com/watch?v=9VUoIruQNMg) `[46:31]`
* [**Standardization, the Symfony Way** - Fabien Potencier at Laracon 2013](https://www.youtube.com/watch?v=0erGiEm07b8) `[1:00:05]`
* [**The State of Laravel** - Taylor Otwell at Laracon 2014](https://www.youtube.com/watch?v=eyDFr7wCIdE) `[1:00:17]`
* [**The Tao of Laravel** - Taylor Otwell at Laracon EU 2015](https://www.youtube.com/watch?v=PRFO4YlHHQU&feature=youtu.be)`[32:53]`
* [**Things Laravel Made Me Believe** - Jeffrey Way at Laracon EU 2015](https://www.youtube.com/watch?v=mDotS5BDqRM) `[53:59]`

[Back to top](#php-must-watch)

### Others
* [**Intl Me This, Intl me That** - Andrei Zmievski at PHP UK Conference 2014](https://www.youtube.com/watch?v=g3M6YzzBEI4) `[51:56]`
* [**Lisp** - Igor Wiedler at Laracon EU 2014](https://www.youtube.com/watch?v=FRaNUsiD_BA) `[56:00]`
* [**Be Awesome in PHPStorm** - Jeffrey Way](https://laracasts.com/series/how-to-be-awesome-in-phpstorm) `~[2:00:00]` (series)
* [**Symfony must watch**](https://github.com/symfony-si/symfony-must-watch) - must watch videos about Symfony

[Back to top](#php-must-watch)

### Advanced
* [**Include Hack - HHVM - PHP++** - Paul Tarjan, Sara Golemon at OSCON 2014](https://www.youtube.com/watch?v=JrPGa1JDX38) `[42:06]`
* [**PHP Under The Hood** - Davey Shafik at PHP UK 2014](https://www.youtube.com/watch?v=bHZX-CM-qQc) `[36:19]`
* [**Abstract Machines** - Igor Wiedler at Laracon 2014](https://www.youtube.com/watch?v=zu_iFwD8MfI) `[1:00:43]`

[Back to top](#php-must-watch)
